/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.GameStageIntegerConfig;
import com.majruszsdifficulty.contexts.base.CustomConditions;
import com.majruszsdifficulty.entities.CreeperlingEntity;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnDeath;
import com.mlib.contexts.OnExplosionDetonate;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@AutoInstance
public class CreeperSplitIntoCreeperlings {
    final GameStageIntegerConfig creeperlingsAmount = new GameStageIntegerConfig(2, 4, 6, (Range<Integer>)new Range((Number)1, (Number)10));

    public CreeperSplitIntoCreeperlings() {
        ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.DEFAULT).name("CreeperSplitIntoCreeperlings").comment("When the Creeper explode it may spawn a few Creeperlings.");
        OnExplosionDetonate.listen(this::spawnCreeperlings).addCondition(CustomConditions.gameStageAtLeast(GameStage.NORMAL)).addCondition(Condition.chanceCRD((double)0.666, (boolean)true)).addCondition(Condition.excludable()).addCondition(Condition.predicate(data -> data.explosion.getExploder() instanceof Creeper && !(data.explosion.getExploder() instanceof CreeperlingEntity))).addConfig((IConfigurable)this.creeperlingsAmount.name("MaxCreeperlings").comment("Maximum amount of Creeperlings to spawn.")).insertTo(group);
        OnExplosionDetonate.listen(this::giveAdvancement).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> data.explosion.getExploder() instanceof CreeperlingEntity)).insertTo(group);
        OnDeath.listen(this::giveAdvancement).addCondition(Condition.predicate(data -> data.attacker instanceof ServerPlayer)).addCondition(Condition.predicate(data -> data.target instanceof CreeperlingEntity)).insertTo(group);
    }

    private void spawnCreeperlings(OnExplosionDetonate.Data data) {
        Creeper creeper = (Creeper)data.explosion.getExploder();
        ServerLevel level = data.getServerLevel();
        int creeperlingsAmount = Random.nextInt((int)1, (int)((Integer)this.creeperlingsAmount.getCurrentGameStageValue() + 1));
        assert (creeper != null && level != null);
        for (int i = 0; i < creeperlingsAmount; ++i) {
            BlockPos position = creeper.m_142538_().m_141952_(Random.nextVector((int)-2, (int)2, (int)-1, (int)1, (int)-2, (int)2).vec3i());
            CreeperlingEntity creeperling = (CreeperlingEntity)((EntityType)Registries.CREEPERLING.get()).m_20600_(level, (CompoundTag)null, null, null, position, MobSpawnType.SPAWNER, true, true);
            if (creeperling == null) continue;
            creeperling.m_6710_(creeper.m_5448_());
        }
    }

    private void giveAdvancement(OnExplosionDetonate.Data data) {
        ServerLevel level = data.getServerLevel();
        Vec3 position = data.event.getExplosion().getPosition();
        Vec3 offset = new Vec3(10.0, 6.0, 10.0);
        List nearbyPlayers = level.m_45976_(ServerPlayer.class, new AABB(position.m_82546_(offset), position.m_82549_(offset)));
        nearbyPlayers.forEach(this::giveAdvancement);
    }

    private void giveAdvancement(OnDeath.Data data) {
        this.giveAdvancement((ServerPlayer)data.attacker);
    }

    private void giveAdvancement(ServerPlayer player) {
        Registries.HELPER.triggerAchievement(player, "encountered_creeperling");
    }
}

