/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entities;

import com.majruszsdifficulty.Registries;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.effects.SoundHandler;
import com.mlib.entities.CustomSkills;
import com.mlib.entities.EntityHelper;
import com.mlib.entities.ICustomSkillProvider;
import com.mlib.goals.CustomMeleeGoal;
import com.mlib.math.AnyPos;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class TankEntity
extends Monster
implements ICustomSkillProvider<Skills> {
    public final Skills skills = new Skills((PathfinderMob)this);

    public static Supplier<EntityType<TankEntity>> createSupplier() {
        return () -> EntityType.Builder.m_20704_(TankEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.99f, 2.7f).m_20712_("tank");
    }

    public static AttributeSupplier getAttributeMap() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 140.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22282_, 3.5).m_22268_(Attributes.f_22278_, 0.75).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 0.5).m_22265_();
    }

    public TankEntity(EntityType<? extends TankEntity> type, Level level) {
        super(type, level);
        this.f_19793_ = 1.0f;
    }

    public Skills getCustomSkills() {
        return this.skills;
    }

    public int m_6552_(Player p_34322_) {
        return Random.nextInt((int)10, (int)17);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_5496_(SoundEvent sound, float volume, float pitch) {
        if (this.m_20067_()) {
            return;
        }
        float randomizedVolume = ((Float)SoundHandler.randomized((float)(volume * 1.25f)).get()).floatValue();
        float randomizedPitch = ((Float)SoundHandler.randomized((float)(pitch * 0.75f)).get()).floatValue();
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, this.m_5720_(), randomizedVolume, randomizedPitch);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CustomMeleeGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.35f;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12383_, 0.15f, 1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        this.skills.tick();
        if (this.m_21527_()) {
            this.m_20254_(8);
        }
    }

    public static class Skills
    extends CustomSkills<SkillType> {
        public Skills(PathfinderMob mob) {
            super(mob, Registries.HELPER.getNetworkChannel(), SkillMessage::new);
        }

        public boolean tryToStart(LivingEntity entity, double distanceSquared) {
            if (Math.sqrt(distanceSquared) >= 2.5) {
                return false;
            }
            if (Random.tryChance((double)0.25)) {
                this.start(SkillType.HEAVY_ATTACK, Utility.secondsToTicks((double)0.9)).onRatio(0.55f, () -> {
                    Level patt5372$temp = this.mob.f_19853_;
                    if (!(patt5372$temp instanceof ServerLevel)) {
                        return;
                    }
                    ServerLevel level = (ServerLevel)patt5372$temp;
                    Vec3 position = this.getSpecialAttackPosition(this.mob.m_20182_(), entity.m_20182_());
                    this.hurtAllEntitiesInRange(level, position);
                    this.spawnGroundParticles(level, position);
                    this.playHitSound();
                });
            } else {
                this.start(Random.tryChance((double)0.5) ? SkillType.STANDARD_LEFT_ATTACK : SkillType.STANDARD_RIGHT_ATTACK, Utility.secondsToTicks((double)0.6)).onRatio(0.45f, () -> {
                    if (Math.sqrt(this.mob.m_20270_((Entity)entity)) < 2.5) {
                        this.tryToHitEntity(entity);
                        this.playHitSound();
                    }
                });
            }
            return true;
        }

        private void hurtAllEntitiesInRange(ServerLevel level, Vec3 position) {
            List entities = EntityHelper.getEntitiesInSphere(LivingEntity.class, (ServerLevel)level, (Vec3)position, (double)3.0, entity -> !entity.m_7306_((Entity)this.mob));
            for (LivingEntity entity2 : entities) {
                ServerPlayer player;
                if (!this.mob.m_21040_(entity2, TargetingConditions.f_26872_)) continue;
                this.mob.m_7327_((Entity)entity2);
                if (!(entity2 instanceof ServerPlayer) || !(player = (ServerPlayer)entity2).m_21254_()) continue;
                player.m_36384_(true);
            }
        }

        private void spawnGroundParticles(ServerLevel level, Vec3 position) {
            Optional<BlockState> blockState = this.getBlockStateBelowPosition((Level)level, position);
            BlockParticleOption blockParticleOption = new BlockParticleOption(ParticleTypes.f_123794_, blockState.orElse(Blocks.f_50493_.m_49966_())).setPos(new BlockPos(position));
            level.m_8767_((ParticleOptions)blockParticleOption, position.f_82479_, position.f_82480_ + 0.25, position.f_82481_, 120, 1.0, 0.25, 1.0, 0.5);
        }

        protected Vec3 getSpecialAttackPosition(Vec3 tankPosition, Vec3 targetPosition) {
            return AnyPos.from((Vec3)targetPosition).sub(tankPosition).norm().mul((Number)1.75).add(tankPosition).vec3();
        }

        private Optional<BlockState> getBlockStateBelowPosition(Level level, Vec3 position) {
            for (int y = (int)position.f_82480_; y > level.m_141937_(); --y) {
                BlockState blockState = level.m_8055_(new BlockPos(position.f_82479_, (double)y, position.f_82481_));
                if (blockState.m_60795_()) continue;
                return Optional.of(blockState);
            }
            return Optional.empty();
        }

        private void tryToHitEntity(LivingEntity entity) {
            if (!this.mob.m_21040_(entity, TargetingConditions.f_26872_)) {
                return;
            }
            this.mob.m_7327_((Entity)entity);
        }

        private void playHitSound() {
            this.mob.m_5496_(SoundEvents.f_12381_, 0.75f, 0.9f);
        }
    }

    public static enum SkillType {
        STANDARD_LEFT_ATTACK,
        STANDARD_RIGHT_ATTACK,
        HEAVY_ATTACK;

    }

    public static class SkillMessage
    extends CustomSkills.Message<SkillType> {
        public SkillMessage(Entity entity, int ticks, SkillType skillType) {
            super(entity, ticks, (Enum)skillType, SkillType::values);
        }

        public SkillMessage() {
            super(SkillType::values);
        }
    }
}

