/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entities;

import com.majruszsdifficulty.Registries;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.blocks.BlockHelper;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.config.StringConfig;
import com.mlib.contexts.OnEntityTick;
import com.mlib.contexts.OnItemTooltip;
import com.mlib.contexts.OnLoot;
import com.mlib.contexts.OnPreDamaged;
import com.mlib.contexts.OnSpawned;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Context;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.data.ISerializable;
import com.mlib.data.JsonListener;
import com.mlib.data.SerializableList;
import com.mlib.data.SerializableStructure;
import com.mlib.effects.ParticleHandler;
import com.mlib.effects.SoundHandler;
import com.mlib.entities.EntityHelper;
import com.mlib.loot.LootHelper;
import com.mlib.math.AnyPos;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import com.mlib.text.TextHelper;
import com.mlib.time.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class CursedArmorEntity
extends Monster {
    public static final String GROUP_ID = Registries.getLocationString("cursed_armor");
    public static final int ASSEMBLE_DURATION = Utility.secondsToTicks((double)2.5);
    boolean areGoalsRegistered = false;
    SoundHandler assembleSound = null;
    int assembleTicksLeft = 0;

    public static Supplier<EntityType<CursedArmorEntity>> createSupplier() {
        return () -> EntityType.Builder.m_20704_(CursedArmorEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 1.9f).m_20712_("cursed_armor");
    }

    public static AttributeSupplier getAttributeMap() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22278_, 0.23).m_22268_(Attributes.f_22284_, 4.0).m_22265_();
    }

    public CursedArmorEntity(EntityType<? extends CursedArmorEntity> type, Level world) {
        super(type, world);
    }

    public boolean m_6040_() {
        return true;
    }

    public int m_6552_(Player player) {
        return Random.nextInt((int)7);
    }

    public void m_8119_() {
        super.m_8119_();
        this.tryToPlaySfx();
        this.assembleTicksLeft = Math.max(this.assembleTicksLeft - 1, 0);
        if (!this.areGoalsRegistered) {
            this.m_8099_();
        }
    }

    public void startAssembling(float yRot) {
        this.assembleTicksLeft = ASSEMBLE_DURATION;
        this.m_146922_(yRot);
        this.m_5616_(yRot);
        this.m_5618_(yRot);
        if (this.f_19853_ instanceof ServerLevel) {
            Time.nextTick(() -> Registries.HELPER.sendMessage(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)new AssembleMessage((Entity)this, yRot)));
        }
    }

    public void setAssembleSound(SoundEvent soundEvent) {
        this.assembleSound = new SoundHandler(soundEvent, SoundSource.HOSTILE, SoundHandler.randomized((float)2.0f));
    }

    public boolean isAssembling() {
        return this.assembleTicksLeft > 0;
    }

    public float getAssembleTime() {
        return (float)Utility.ticksToSeconds((int)(ASSEMBLE_DURATION - this.assembleTicksLeft));
    }

    protected void m_8099_() {
        if (this.isAssembling() || this.f_19797_ <= ASSEMBLE_DURATION / 3) {
            return;
        }
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.areGoalsRegistered = true;
    }

    private void tryToPlaySfx() {
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (this.assembleTicksLeft == ASSEMBLE_DURATION) {
            SoundHandler.ENCHANT.play((Level)level2, this.m_20182_());
        } else if (this.assembleTicksLeft == ASSEMBLE_DURATION - 35) {
            this.assembleSound.play((Level)level2, this.m_20182_());
        }
    }

    static {
        ModConfigs.init((String)Registries.Groups.MOBS, (String)GROUP_ID).name("CursedArmor");
    }

    public static class AssembleMessage
    extends SerializableStructure {
        int entityId;
        float yRot;

        public AssembleMessage() {
            this.defineInteger("id", () -> this.entityId, x -> {
                this.entityId = x;
            });
            this.defineFloat("rot", () -> Float.valueOf(this.yRot), x -> {
                this.yRot = x.floatValue();
            });
        }

        public AssembleMessage(Entity entity, float yRot) {
            this();
            this.entityId = entity.m_142049_();
            this.yRot = yRot;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onClient(NetworkEvent.Context context) {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(this.entityId)) instanceof CursedArmorEntity) {
                CursedArmorEntity cursedArmor = (CursedArmorEntity)entity;
                cursedArmor.startAssembling(this.yRot);
            }
        }
    }

    public static class LocationDef
    extends SerializableStructure {
        ResourceLocation loot;
        List<ResourceLocation> chests;
        ResourceLocation sound = new ResourceLocation("item.armor.equip_generic");
        float chance = 0.0f;

        public LocationDef() {
            this.defineLocation("loot", () -> this.loot, x -> {
                this.loot = x;
            });
            this.defineLocation("chests", () -> this.chests, x -> {
                this.chests = x;
            });
            this.defineLocation("sound", () -> this.sound, x -> {
                this.sound = x;
            });
            this.defineFloat("chance", () -> Float.valueOf(this.chance), x -> {
                this.chance = x.floatValue();
            });
        }
    }

    public static class LocationsDef
    extends SerializableList {
        List<LocationDef> locationDefs = new ArrayList<LocationDef>();

        public LocationsDef() {
            this.defineCustom(() -> this.locationDefs, x -> {
                this.locationDefs = x;
            }, LocationDef::new);
        }

        public Optional<LocationDef> find(ResourceLocation chestId) {
            return this.locationDefs.stream().filter(locationDef -> locationDef.chests.stream().anyMatch(arg_0 -> ((ResourceLocation)chestId).equals(arg_0))).findFirst();
        }

        public LocationDef getRandom() {
            return (LocationDef)((Object)Random.next(this.locationDefs));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onClient(NetworkEvent.Context context) {
            Registries.HELPER.findInstance(Spawn.class).ifPresent(instance -> instance.locationsDef.onSync((ISerializable)this));
        }
    }

    @AutoInstance
    public static class Effects {
        public Effects() {
            this.createOnTick(this::spawnIdleParticles);
            this.createOnTick(this::spawnAssemblingParticles).addCondition(Condition.predicate(data -> {
                CursedArmorEntity cursedArmor;
                LivingEntity patt12553$temp = data.entity;
                return patt12553$temp instanceof CursedArmorEntity && (cursedArmor = (CursedArmorEntity)patt12553$temp).isAssembling();
            }));
        }

        private Context<OnEntityTick.Data> createOnTick(Consumer<OnEntityTick.Data> consumer) {
            return OnEntityTick.listen(consumer).addCondition(Condition.isServer()).addCondition(Condition.cooldown((double)0.2, (Dist)Dist.DEDICATED_SERVER).configurable(false)).addCondition(Condition.predicate(data -> data.entity instanceof CursedArmorEntity));
        }

        private void spawnIdleParticles(OnEntityTick.Data data) {
            CursedArmorEntity cursedArmor = (CursedArmorEntity)data.entity;
            this.spawnParticles(data, new Vec3(0.0, (double)cursedArmor.m_20206_() * 0.5, 0.0), 0.3, 1);
        }

        private void spawnAssemblingParticles(OnEntityTick.Data data) {
            this.spawnParticles(data, new Vec3(0.0, 0.0, 0.0), 0.6, 5);
        }

        private void spawnParticles(OnEntityTick.Data data, Vec3 emitterOffset, double offsetMultiplier, int particlesCount) {
            CursedArmorEntity cursedArmor = (CursedArmorEntity)data.entity;
            Vec3 position = cursedArmor.m_20182_().m_82549_(emitterOffset);
            Vec3 offset = AnyPos.from((Number)Float.valueOf(cursedArmor.m_20205_()), (Number)Float.valueOf(cursedArmor.m_20206_()), (Number)Float.valueOf(cursedArmor.m_20205_())).mul((Number)offsetMultiplier).vec3();
            ParticleHandler.ENCHANTED_GLYPH.spawn(data.getServerLevel(), position, particlesCount, () -> offset, () -> Float.valueOf(0.5f));
        }
    }

    @AutoInstance
    public static class Spawn {
        final DoubleConfig dropChance = new DoubleConfig(0.2, Range.CHANCE);
        final StringConfig name = new StringConfig("Freshah");
        final JsonListener.Holder<LocationsDef> locationsDef = JsonListener.add((String)"custom", (ResourceLocation)Registries.getLocation("cursed_armor_locations"), LocationsDef.class, LocationsDef::new).syncWithClients(Registries.HELPER);

        public Spawn() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)GROUP_ID);
            OnLoot.listen(this::spawnCursedArmor).addCondition(Condition.isServer()).addCondition(OnLoot.hasOrigin()).addCondition(Condition.predicate(data -> BlockHelper.getBlockEntity((Level)data.getLevel(), (Vec3)data.origin) instanceof ChestBlockEntity)).addCondition(this.isLootDefined()).addConfig((IConfigurable)this.dropChance.name("drop_chance").comment("Chance for each equipped item to drop when killed.")).insertTo(group);
            OnSpawned.listen(this::setCustomName).name("CustomName").comment("Makes some Cursed Armors have a custom name.").addCondition(Condition.isServer()).addCondition(Condition.chance((double)0.025)).addCondition(OnSpawned.isNotLoadedFromDisk()).addCondition(Condition.predicate(data -> data.target instanceof CursedArmorEntity)).addConfigs(new IConfigurable[]{this.name.name("name")}).insertTo(group);
            OnSpawned.listenSafe(this::giveRandomArmor).addCondition(Condition.isServer()).addCondition(OnSpawned.isNotLoadedFromDisk()).addCondition(Condition.predicate(data -> data.target instanceof CursedArmorEntity)).insertTo(group);
            OnSpawned.listen(this::startAssembling).addCondition(OnSpawned.isNotLoadedFromDisk()).addCondition(Condition.predicate(data -> {
                CursedArmorEntity cursedArmor;
                LivingEntity patt8187$temp = data.target;
                return patt8187$temp instanceof CursedArmorEntity && !(cursedArmor = (CursedArmorEntity)patt8187$temp).isAssembling();
            })).insertTo(group);
            OnPreDamaged.listen((Consumer)OnPreDamaged.CANCEL).addCondition(Condition.predicate(data -> {
                CursedArmorEntity cursedArmor;
                LivingEntity patt8396$temp = data.target;
                return patt8396$temp instanceof CursedArmorEntity && (cursedArmor = (CursedArmorEntity)patt8396$temp).isAssembling();
            })).insertTo(group);
            OnItemTooltip.listen(this::addSpawnInfo).addCondition(Condition.predicate(data -> data.itemStack.m_41720_().equals(Registries.CURSED_ARMOR_SPAWN_EGG.get())));
        }

        private void spawnCursedArmor(OnLoot.Data data) {
            CursedArmorEntity cursedArmor = (CursedArmorEntity)EntityHelper.createSpawner(Registries.CURSED_ARMOR, (Level)data.getLevel()).position(this.getSpawnPosition(data)).spawn();
            if (cursedArmor != null) {
                float yRot = ((Direction)BlockHelper.getBlockState((Level)data.getLevel(), (Vec3)data.origin).m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
                cursedArmor.startAssembling(yRot);
                this.equipSet(((LocationsDef)this.locationsDef.get()).find(data.context.getQueriedLootTableId()).orElseThrow(), cursedArmor, data.origin);
                Entity entity = data.entity;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    Time.nextTick(() -> ((ServerPlayer)player).m_6915_());
                }
            }
        }

        private Vec3 getSpawnPosition(OnLoot.Data data) {
            Vec3 origin;
            ServerLevel level = data.getServerLevel();
            Function<Float, Boolean> isAir = arg_0 -> Spawn.lambda$getSpawnPosition$6(level, origin = data.origin, arg_0);
            if (isAir.apply(Float.valueOf(1.0f)).booleanValue() && isAir.apply(Float.valueOf(2.0f)).booleanValue()) {
                return origin.m_82520_(0.0, 0.5, 0.0);
            }
            Vec3i offset = ((Direction)BlockHelper.getBlockState((Level)level, (Vec3)data.origin).m_61143_((Property)ChestBlock.f_51478_)).m_122436_();
            return origin.m_82520_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
        }

        private Condition<OnLoot.Data> isLootDefined() {
            return Condition.predicate(data -> {
                Optional<LocationDef> locationDef = ((LocationsDef)this.locationsDef.get()).find(data.context.getQueriedLootTableId());
                return locationDef.isPresent() && Random.tryChance((double)locationDef.get().chance);
            });
        }

        private void setCustomName(OnSpawned.Data data) {
            data.target.m_6593_((Component)new TextComponent((String)this.name.get()));
        }

        private void giveRandomArmor(OnSpawned.Data data) {
            CursedArmorEntity cursedArmor = (CursedArmorEntity)data.target;
            if (cursedArmor.m_21207_() > 0.0f) {
                return;
            }
            this.equipSet(((LocationsDef)this.locationsDef.get()).getRandom(), cursedArmor, cursedArmor.m_20182_());
        }

        private void equipSet(LocationDef locationDef, CursedArmorEntity cursedArmor, Vec3 position) {
            LootContext lootContext = new LootContext.Builder((ServerLevel)cursedArmor.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)position).m_78972_(LootContextParams.f_81455_, (Object)cursedArmor).m_78975_(LootContextParamSets.f_81416_);
            LootHelper.getLootTable((ResourceLocation)locationDef.loot).m_79129_(lootContext).forEach(arg_0 -> ((CursedArmorEntity)cursedArmor).m_21540_(arg_0));
            Arrays.stream(EquipmentSlot.values()).forEach(slot -> cursedArmor.m_21409_((EquipmentSlot)slot, this.dropChance.asFloat()));
            cursedArmor.setAssembleSound((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(locationDef.sound));
        }

        private void startAssembling(OnSpawned.Data data) {
            CursedArmorEntity cursedArmor = (CursedArmorEntity)data.target;
            cursedArmor.startAssembling(0.0f);
        }

        private void addSpawnInfo(OnItemTooltip.Data data) {
            List components = data.tooltip;
            components.add(new TranslatableComponent("item.majruszsdifficulty.cursed_armor_spawn_egg.locations").m_130940_(ChatFormatting.GRAY));
            ((LocationsDef)this.locationsDef.get()).locationDefs.forEach(locationDef -> {
                String chance = TextHelper.percent((float)locationDef.chance);
                locationDef.chests.forEach(chestId -> components.add(new TextComponent(" - ").m_7220_((Component)new TextComponent(chestId.toString())).m_7220_((Component)new TextComponent(" ")).m_7220_((Component)new TextComponent(chance).m_130940_(ChatFormatting.DARK_GRAY)).m_130940_(ChatFormatting.GRAY)));
            });
        }

        private static /* synthetic */ Boolean lambda$getSpawnPosition$6(ServerLevel level, Vec3 origin, Float y) {
            return BlockHelper.getBlockState((Level)level, (Vec3)origin.m_82520_(0.0, (double)y.floatValue(), 0.0)).m_60795_();
        }
    }
}

