/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entities;

import com.majruszsdifficulty.Registries;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.config.ConfigGroup;
import com.mlib.config.EffectConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnDamaged;
import com.mlib.contexts.OnEffectApplicable;
import com.mlib.contexts.OnEntityTick;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.effects.ParticleHandler;
import com.mlib.effects.SoundHandler;
import com.mlib.entities.CustomSkills;
import com.mlib.entities.EntityHelper;
import com.mlib.entities.ICustomSkillProvider;
import com.mlib.goals.CustomMeleeGoal;
import com.mlib.math.AnyPos;
import com.mlib.modhelper.AutoInstance;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.Event;

public class CerberusEntity
extends Monster
implements ICustomSkillProvider<Skills> {
    static final String GROUP_ID = Registries.getLocationString("cerberus");
    public final Skills skills = new Skills((PathfinderMob)this);

    public static Supplier<EntityType<CerberusEntity>> createSupplier() {
        return () -> EntityType.Builder.m_20704_(CerberusEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.2f, 1.75f).m_20712_("cerberus");
    }

    public static AttributeSupplier getAttributeMap() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 240.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 0.5).m_22265_();
    }

    public CerberusEntity(EntityType<? extends CerberusEntity> type, Level world) {
        super(type, world);
        this.f_19793_ = 1.0f;
    }

    public Skills getCustomSkills() {
        return this.skills;
    }

    public int m_6552_(Player p_34322_) {
        return Random.nextInt((int)60, (int)90);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_5496_(SoundEvent sound, float volume, float pitch) {
        if (this.m_20067_()) {
            return;
        }
        float randomizedVolume = ((Float)SoundHandler.randomized((float)volume).get()).floatValue();
        float randomizedPitch = ((Float)SoundHandler.randomized((float)(pitch * 0.75f)).get()).floatValue();
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, this.m_5720_(), randomizedVolume, randomizedPitch);
    }

    public void m_8119_() {
        super.m_8119_();
        this.skills.tick();
        if (this.m_21527_()) {
            this.m_20254_(8);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CustomMeleeGoal((PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 1.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 2, true, false, this::isValidTarget));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12619_;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.6f;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12561_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12560_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12562_, 0.15f, 1.0f);
    }

    private boolean isValidTarget(LivingEntity entity) {
        return !entity.m_6336_().equals(MobType.f_21641_) && !Registries.getUndeadArmyManager().isPartOfUndeadArmy((Entity)entity);
    }

    static {
        ModConfigs.init((String)Registries.Groups.MOBS, (String)GROUP_ID).name("Cerberus");
    }

    public static class Skills
    extends CustomSkills<SkillType> {
        int fireballCooldownLeft = 0;

        public Skills(PathfinderMob mob) {
            super(mob, Registries.HELPER.getNetworkChannel(), SkillMessage::new);
        }

        public boolean tryToStart(LivingEntity entity, double distanceSquared) {
            Level level = this.mob.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return false;
            }
            ServerLevel level2 = (ServerLevel)level;
            double distance = Math.sqrt(distanceSquared);
            if (distance < 3.5 && this.mob.m_21040_(entity, TargetingConditions.f_26872_)) {
                Vec3 position = this.getAttackPosition(this.mob.m_20182_(), entity.m_20182_());
                this.start(SkillType.BITE, Utility.secondsToTicks((double)0.7)).onTick(2, () -> this.mob.m_5496_(SoundEvents.f_12617_, 0.5f, 0.85f)).onTick(3, () -> this.mob.m_5496_(SoundEvents.f_12617_, 0.5f, 0.7f)).onTick(4, () -> this.mob.m_5496_(SoundEvents.f_12617_, 0.5f, 1.0f)).onRatio(0.55f, () -> this.hurtAllEntitiesInRange(level2, position));
                return true;
            }
            if (distance >= 10.0 && this.fireballCooldownLeft == 0) {
                this.start(SkillType.FIRE_BREATH, Utility.secondsToTicks((double)1.4)).onRatio(0.25f, () -> this.spawnFireballTowards(entity)).onRatio(0.5f, () -> this.spawnFireballTowards(entity)).onRatio(0.75f, () -> this.spawnFireballTowards(entity));
                this.fireballCooldownLeft = Utility.secondsToTicks((double)10.0);
                return true;
            }
            return false;
        }

        public void tick() {
            super.tick();
            this.fireballCooldownLeft = Math.max(this.fireballCooldownLeft - 1, 0);
        }

        private void hurtAllEntitiesInRange(ServerLevel level, Vec3 position) {
            List entities = EntityHelper.getEntitiesInSphere(LivingEntity.class, (ServerLevel)level, (Vec3)position, (double)2.5, entity -> !entity.m_7306_((Entity)this.mob));
            for (LivingEntity entity2 : entities) {
                ServerPlayer player;
                if (!this.mob.m_21040_(entity2, TargetingConditions.f_26872_)) continue;
                this.mob.m_7327_((Entity)entity2);
                if (!(entity2 instanceof ServerPlayer) || !(player = (ServerPlayer)entity2).m_21254_()) continue;
                player.m_36384_(true);
            }
        }

        private Vec3 getAttackPosition(Vec3 pos1, Vec3 pos2) {
            return AnyPos.from((Vec3)pos2).sub(pos1).norm().mul((Number)1.75).add(pos1).vec3();
        }

        private void spawnFireballTowards(LivingEntity target) {
            Vec3 offset = AnyPos.from((Vec3)target.m_20182_()).sub(this.mob.m_20182_()).vec3();
            for (double angle : new double[]{-30.0, 0.0, 30.0}) {
                Vec3 power = AnyPos.from((Vec3)offset).mul(Random.nextVector((double)0.8, (double)1.2, (double)0.8, (double)1.2, (double)0.8, (double)1.2)).vec3();
                double cos = Math.cos(Math.toRadians(angle));
                double sin = Math.sin(Math.toRadians(angle));
                Vec3 normalized = AnyPos.from((Vec3)offset).norm().vec3();
                normalized = new Vec3(cos * normalized.f_82479_ - sin * normalized.f_82481_, normalized.f_82480_, sin * normalized.f_82479_ + cos * normalized.f_82481_);
                Vec3 spawnPosition = AnyPos.from((Vec3)this.mob.m_20182_()).add(normalized).add((Number)0.0, (Number)Random.nextDouble((double)1.2, (double)1.5), (Number)0.0).vec3();
                SmallFireball fireball = new SmallFireball(this.mob.f_19853_, (LivingEntity)this.mob, power.f_82479_, power.f_82480_, power.f_82481_);
                fireball.m_6034_(spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_);
                fireball.m_20256_(AnyPos.from((Vec3)power).norm().mul((Number)0.25).vec3());
                this.mob.f_19853_.m_7967_((Entity)fireball);
            }
            SoundHandler.SMELT.play(this.mob.f_19853_, this.mob.m_20182_());
        }
    }

    public static enum SkillType {
        BITE,
        FIRE_BREATH;

    }

    @AutoInstance
    public static class WitherAttack {
        final EffectConfig wither = new EffectConfig(MobEffects.f_19615_, 1, 10.0);

        public WitherAttack() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)GROUP_ID);
            OnDamaged.listen(this::applyWither).addCondition(OnDamaged.isDirect()).addCondition(OnDamaged.dealtAnyDamage()).addCondition(Condition.predicate(data -> data.attacker instanceof CerberusEntity)).addConfig((IConfigurable)this.wither.name("Wither")).insertTo(group);
            OnEffectApplicable.listen(this::cancelEffect).addCondition(Condition.predicate(data -> data.effect.equals(MobEffects.f_19615_))).addCondition(Condition.predicate(data -> data.entity instanceof CerberusEntity)).insertTo(group);
            OnEntityTick.listen(this::spawnParticle).addCondition(Condition.isServer()).addCondition(Condition.cooldown((int)4, (Dist)Dist.DEDICATED_SERVER).configurable(false)).addCondition(Condition.predicate(data -> data.entity instanceof CerberusEntity)).insertTo(group);
        }

        private void applyWither(OnDamaged.Data data) {
            this.wither.apply(data.target);
        }

        private void cancelEffect(OnEffectApplicable.Data data) {
            data.event.setResult(Event.Result.DENY);
        }

        private void spawnParticle(OnEntityTick.Data data) {
            ParticleHandler.SMOKE.spawn(data.getServerLevel(), data.entity.m_20182_().m_82520_(0.0, 0.75, 0.0), 3, () -> new Vec3(0.25, 0.5, 0.25));
        }
    }

    public static class SkillMessage
    extends CustomSkills.Message<SkillType> {
        public SkillMessage(Entity entity, int ticks, SkillType skillType) {
            super(entity, ticks, (Enum)skillType, SkillType::values);
        }

        public SkillMessage() {
            super(SkillType::values);
        }
    }
}

