/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.BleedingConfig;
import com.majruszsdifficulty.contexts.OnBleedingCheck;
import com.majruszsdifficulty.contexts.OnBleedingTooltip;
import com.majruszsdifficulty.gui.BleedingGui;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.config.BooleanConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.config.StringListConfig;
import com.mlib.contexts.OnDamaged;
import com.mlib.contexts.OnDeath;
import com.mlib.contexts.OnEffectApplicable;
import com.mlib.contexts.OnEntityTick;
import com.mlib.contexts.OnItemAttributeTooltip;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.data.SerializableStructure;
import com.mlib.effects.ParticleHandler;
import com.mlib.entities.EntityHelper;
import com.mlib.mobeffects.MobEffectHelper;
import com.mlib.modhelper.AutoInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class BleedingEffect
extends MobEffect {
    public BleedingEffect() {
        super(MobEffectCategory.HARMFUL, -2271915);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
    }

    public void m_19461_(@Nullable Entity source, @Nullable Entity indirectSource, LivingEntity entity, int amplifier, double health) {
    }

    public boolean m_6584_(int duration, int amplifier) {
        return false;
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    public static class BloodMessage
    extends SerializableStructure {
        int entityId;

        public BloodMessage() {
            this.defineInteger("id", () -> this.entityId, x -> {
                this.entityId = x;
            });
        }

        public BloodMessage(Entity entity) {
            this();
            this.entityId = entity.m_142049_();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onClient(NetworkEvent.Context context) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && minecraft.f_91073_.m_6815_(this.entityId) == minecraft.f_91074_) {
                BleedingGui.addBloodOnScreen(3);
            }
        }
    }

    @AutoInstance
    public static class Bleeding {
        static final ParticleHandler PARTICLES = new ParticleHandler(Registries.BLOOD, () -> new Vec3(0.2, 0.5, 0.2), ParticleHandler.speed((float)0.075f));
        static final int BLOOD_TICK_COOLDOWN = Utility.secondsToTicks((double)4.0);
        final BooleanConfig availability = Condition.DefaultConfigs.excludable((boolean)true);
        final StringListConfig immuneMobs = new StringListConfig(new String[]{"minecraft:skeleton_horse", "minecraft:zombie_horse"});
        final BleedingConfig effect = new BleedingConfig();
        final HashMap<Integer, Integer> entityTicks = new HashMap();

        public Bleeding() {
            ConfigGroup group = ModConfigs.getGroup((String)Registries.Groups.BLEEDING).addConfig((IConfigurable)this.availability).addConfig((IConfigurable)this.immuneMobs.name("immune_mobs").comment("Specifies which mobs should not be affected by Bleeding (all undead mobs are immune by default).")).addConfig((IConfigurable)this.effect);
            OnEntityTick.listen(this::spawnParticles).addCondition(Condition.isServer()).addCondition(Condition.cooldown((int)3, (Dist)Dist.DEDICATED_SERVER).configurable(false)).addCondition(Condition.hasEffect(Registries.BLEEDING, data -> data.entity)).insertTo(group);
            OnEntityTick.listen(this::tick).addCondition(Condition.isServer()).addCondition(Condition.hasEffect(Registries.BLEEDING, data -> data.entity)).insertTo(group);
            OnDeath.listen(this::spawnParticles).addCondition(Condition.isServer()).addCondition(Condition.hasEffect(Registries.BLEEDING, data -> data.target)).insertTo(group);
            OnEffectApplicable.listen(this::cancelEffect).addCondition(Condition.predicate(data -> this.availability.isDisabled())).addCondition(Condition.predicate(data -> data.effect.equals(Registries.BLEEDING_IMMUNITY.get()))).insertTo(group);
            OnDamaged.listen(this::applyBleeding).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> this.availability.isEnabled())).addCondition(Condition.predicate(this::isNotImmune)).addCondition(OnDamaged.dealtAnyDamage()).insertTo(group);
            OnItemAttributeTooltip.listen(this::addCustomTooltip).addCondition(Condition.predicate(data -> this.availability.isEnabled())).insertTo(group);
        }

        private void spawnParticles(OnEntityTick.Data data) {
            int amplifier = MobEffectHelper.getAmplifier((LivingEntity)data.entity, (MobEffect)((MobEffect)Registries.BLEEDING.get()));
            float walkDistanceDelta = EntityHelper.getWalkDistanceDelta((LivingEntity)data.entity);
            this.spawnParticles(data.getServerLevel(), (Entity)data.entity, Random.round((double)(1.0 + (15.0 + (double)amplifier) * (double)walkDistanceDelta)));
        }

        private void tick(OnEntityTick.Data data) {
            LivingEntity entity = data.entity;
            int amplifier = MobEffectHelper.getAmplifier((LivingEntity)entity, (MobEffect)((MobEffect)Registries.BLEEDING.get()));
            int extraDuration = Random.round((double)(0.3 * (double)(amplifier + 2) * (7.26 * (double)EntityHelper.getWalkDistanceDelta((LivingEntity)entity) + 1.0)));
            int duration = this.entityTicks.getOrDefault(entity.m_142049_(), 0) + extraDuration;
            if (duration >= BLOOD_TICK_COOLDOWN) {
                this.dealDamage(entity);
                duration = 0;
            }
            this.entityTicks.put(entity.m_142049_(), duration);
        }

        private void dealDamage(LivingEntity entity) {
            net.minecraft.world.effect.MobEffectInstance mobEffectInstance = entity.m_21124_((MobEffect)Registries.BLEEDING.get());
            if (mobEffectInstance instanceof MobEffectInstance) {
                MobEffectInstance effectInstance = (MobEffectInstance)mobEffectInstance;
                Vec3 motion = entity.m_20184_();
                entity.m_6469_((net.minecraft.world.damagesource.DamageSource)new DamageSource(effectInstance.damageSourceEntity), 1.0f);
                entity.m_20256_(motion);
            } else {
                entity.m_6469_(Registries.BLEEDING_SOURCE, 1.0f);
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Registries.HELPER.sendMessage(PacketDistributor.PLAYER.with(() -> player), (Object)new BloodMessage((Entity)player));
            }
            this.entityTicks.put(entity.m_142049_(), 0);
        }

        private void spawnParticles(OnDeath.Data data) {
            this.spawnParticles(data.getServerLevel(), (Entity)data.target, 100);
        }

        private void spawnParticles(ServerLevel level, Entity entity, int amountOfParticles) {
            Vec3 position = new Vec3(entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_());
            PARTICLES.spawn(level, position, amountOfParticles);
        }

        private void cancelEffect(OnEffectApplicable.Data data) {
            data.event.setResult(Event.Result.DENY);
        }

        private void applyBleeding(OnDamaged.Data data) {
            OnBleedingCheck.Data bleedingData = OnBleedingCheck.dispatch(data.event);
            if (bleedingData.dealtAnyDamage() && bleedingData.isEffectTriggered() && this.effect.apply(data)) {
                this.dealDamage(data.target);
            }
        }

        private boolean isNotImmune(OnDamaged.Data data) {
            return !this.immuneMobs.contains(Utility.getRegistryString((LivingEntity)data.target));
        }

        private void addCustomTooltip(OnItemAttributeTooltip.Data data) {
            OnBleedingTooltip.dispatch(data.itemStack, this.effect.getAmplifier()).addAll(data);
        }
    }

    public static class MobEffectInstance
    extends net.minecraft.world.effect.MobEffectInstance {
        @Nullable
        protected final Entity damageSourceEntity;

        public MobEffectInstance(int duration, int amplifier, boolean ambient, @Nullable LivingEntity attacker) {
            super((MobEffect)Registries.BLEEDING.get(), duration, amplifier, ambient, false, true);
            this.damageSourceEntity = attacker;
        }
    }

    public static class DamageSource
    extends net.minecraft.world.damagesource.DamageSource {
        @Nullable
        protected final Entity damageSourceEntity;

        public DamageSource(@Nullable Entity damageSourceEntity) {
            super(Registries.BLEEDING_SOURCE.f_19326_);
            this.damageSourceEntity = damageSourceEntity;
            this.m_19380_();
        }

        @Nullable
        public Entity m_7640_() {
            return null;
        }

        @Nullable
        public Entity m_7639_() {
            return this.damageSourceEntity;
        }
    }
}

