/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.config;

import com.majruszsdifficulty.goals.FollowGroupLeaderGoal;
import com.majruszsdifficulty.goals.TargetAsLeaderGoal;
import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.config.IntegerConfig;
import com.mlib.entities.EntityHelper;
import com.mlib.items.ItemHelper;
import com.mlib.levels.LevelHelper;
import com.mlib.loot.LootHelper;
import com.mlib.math.AnyPos;
import com.mlib.math.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MobGroupConfig
extends ConfigGroup {
    public static final String SIDEKICK_TAG = "MajruszsDifficultySidekick";
    public static final String LEADER_TAG = "MajruszsDifficultyLeader";
    static final Range<Integer> RANGE = new Range((Number)1, (Number)9);
    final Supplier<EntityType<? extends PathfinderMob>> mob;
    final IntegerConfig min;
    final IntegerConfig max;
    final ResourceLocation leaderSet;
    final ResourceLocation sidekickSet;

    public MobGroupConfig(Supplier<EntityType<? extends PathfinderMob>> mob, Range<Integer> range, ResourceLocation leaderSet, ResourceLocation sidekickSet) {
        super(new IConfigurable[0]);
        this.mob = mob;
        this.min = new IntegerConfig(((Integer)range.from).intValue(), RANGE);
        this.max = new IntegerConfig(((Integer)range.to).intValue(), RANGE);
        this.leaderSet = leaderSet;
        this.sidekickSet = sidekickSet;
        this.addConfig((IConfigurable)this.min.name("min_count").comment("Minimum amount of extra mobs to spawn."));
        this.addConfig((IConfigurable)this.max.name("max_count").comment("Maximum amount of extra mobs to spawn."));
    }

    public List<PathfinderMob> spawn(PathfinderMob leader) {
        int sidekickAmount = Random.nextInt((int)this.getMinCount(), (int)(this.getMaxCount() + 1));
        ArrayList<PathfinderMob> sidekicks = new ArrayList<PathfinderMob>();
        for (int idx = 0; idx < sidekickAmount; ++idx) {
            PathfinderMob sidekick = (PathfinderMob)EntityHelper.createSpawner(this.getMob(), (Level)leader.f_19853_).position(this.getRandomizedPosition(leader.f_19853_, leader.m_20182_())).spawn();
            if (sidekick == null) continue;
            this.addSidekickGoals(sidekick, leader);
            this.markAsSidekick(sidekick);
            this.applyArmorSet(sidekick, this.sidekickSet);
            sidekicks.add(sidekick);
        }
        this.markAsLeader(leader);
        this.applyArmorSet(leader, this.leaderSet);
        return sidekicks;
    }

    public EntityType<? extends PathfinderMob> getMob() {
        return this.mob.get();
    }

    public int getMinCount() {
        return Math.min((Integer)this.min.get(), (Integer)this.max.get());
    }

    public int getMaxCount() {
        return Math.max((Integer)this.min.get(), (Integer)this.max.get());
    }

    private void addSidekickGoals(PathfinderMob sidekick, PathfinderMob leader) {
        sidekick.f_21345_.m_25352_(9, (Goal)new FollowGroupLeaderGoal((Mob)sidekick, (Mob)leader, 1.0, 6.0f, 5.0f));
        sidekick.f_21346_.m_25352_(9, (Goal)new TargetAsLeaderGoal(sidekick, leader));
    }

    private void markAsSidekick(PathfinderMob sidekick) {
        sidekick.getPersistentData().m_128379_(SIDEKICK_TAG, true);
    }

    private void markAsLeader(PathfinderMob leader) {
        leader.getPersistentData().m_128379_(LEADER_TAG, true);
    }

    private void applyArmorSet(PathfinderMob mob, ResourceLocation location) {
        if (location == null) {
            return;
        }
        LootHelper.getLootTable((ResourceLocation)location).m_79129_(LootHelper.toGiftContext((Entity)mob)).forEach(itemStack -> ItemHelper.equip((Mob)mob, (ItemStack)itemStack));
        Arrays.stream(EquipmentSlot.values()).forEach(slot -> mob.m_21409_(slot, 0.05f));
    }

    private Vec3 getRandomizedPosition(Level level, Vec3 position) {
        for (int idx = 0; idx < 3; ++idx) {
            Vec3 newPosition = AnyPos.from((Vec3)position).add((Number)Random.nextInt((int)-3, (int)4), (Number)0.0, (Number)Random.nextInt((int)-3, (int)4)).vec3();
            Optional spawnPoint = LevelHelper.findBlockPosOnGround((Level)level, (Number)newPosition.f_82479_, (Range)new Range((Number)(newPosition.f_82480_ - 3.0), (Number)(newPosition.f_82480_ + 3.0)), (Number)newPosition.f_82481_);
            if (!spawnPoint.isPresent()) continue;
            return AnyPos.from((BlockPos)((BlockPos)spawnPoint.get())).add((Number)0.5, (Number)0.0, (Number)0.5).vec3();
        }
        return position;
    }
}

