/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.config;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.ProgressiveEffectConfig;
import com.majruszsdifficulty.effects.BleedingEffect;
import com.majruszsdifficulty.gamestage.GameStage;
import com.mlib.contexts.OnDamaged;
import com.mlib.mobeffects.MobEffectHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class BleedingConfig
extends ProgressiveEffectConfig {
    public BleedingConfig(GameStage.Double duration) {
        super(Registries.BLEEDING, new GameStage.Integer(0, 1, 2), duration);
    }

    public BleedingConfig(double duration) {
        this(new GameStage.Double(duration, duration, duration));
    }

    public BleedingConfig() {
        this(24.0);
    }

    public boolean apply(OnDamaged.Data data) {
        LivingEntity target = data.target;
        LivingEntity attacker = data.attacker;
        BleedingEffect.MobEffectInstance effectInstance = new BleedingEffect.MobEffectInstance(this.getDuration(), this.getAmplifier(), false, attacker);
        if (!MobEffectHelper.tryToApply((LivingEntity)target, (MobEffectInstance)effectInstance)) {
            return false;
        }
        if (target instanceof ServerPlayer) {
            ServerPlayer targetPlayer = (ServerPlayer)target;
            Registries.HELPER.triggerAchievement(targetPlayer, "bleeding_received");
            if (data.source.equals(DamageSource.f_19314_)) {
                Registries.HELPER.triggerAchievement(targetPlayer, "cactus_bleeding");
            }
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer attackerPlayer = (ServerPlayer)attacker;
            Registries.HELPER.triggerAchievement(attackerPlayer, "bleeding_inflicted");
        }
        return true;
    }
}

