/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.commands;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.MobGroupConfig;
import com.majruszsdifficulty.features.groups.PiglinsInGroup;
import com.majruszsdifficulty.features.groups.SkeletonsInGroup;
import com.majruszsdifficulty.features.groups.ZombiesInGroup;
import com.majruszsdifficulty.undeadarmy.UndeadArmyPatrol;
import com.mlib.commands.Command;
import com.mlib.commands.CommandData;
import com.mlib.entities.EntityHelper;
import com.mlib.modhelper.AutoInstance;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;

@AutoInstance
public class SummonMobGroupCommand
extends Command {
    public SummonMobGroupCommand() {
        this.newBuilder().literal(new String[]{"summongroup"}).enumeration(GroupType.class).hasPermission(4).execute(this::handle);
    }

    private int handle(CommandData data) throws CommandSyntaxException {
        Entity entity = this.getOptionalEntityOrPlayer(data);
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            GroupType groupType = (GroupType)this.getEnumeration(data, GroupType.class);
            PathfinderMob mob = (PathfinderMob)EntityHelper.createSpawner(groupType.entityType, (Level)level2).position(entity.m_20182_()).mobSpawnType(MobSpawnType.COMMAND).spawn();
            if (mob != null) {
                Registries.HELPER.findInstance(groupType.clazz).ifPresent(instance -> ((MobGroupConfig)((Object)((Object)instance.get()))).spawn(mob));
            }
        }
        return 0;
    }

    static enum GroupType {
        ZOMBIE((EntityType<? extends PathfinderMob>)EntityType.f_20501_, ZombiesInGroup.class),
        SKELETONS((EntityType<? extends PathfinderMob>)EntityType.f_20524_, SkeletonsInGroup.class),
        PIGLINS((EntityType<? extends PathfinderMob>)EntityType.f_20511_, PiglinsInGroup.class),
        UNDEAD_ARMY((EntityType<? extends PathfinderMob>)EntityType.f_20524_, UndeadArmyPatrol.class);

        final EntityType<? extends PathfinderMob> entityType;
        final Class<? extends Supplier<MobGroupConfig>> clazz;

        private GroupType(EntityType<? extends PathfinderMob> entityType, Class<? extends Supplier<MobGroupConfig>> clazz) {
            this.entityType = entityType;
            this.clazz = clazz;
        }
    }
}

