/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty;

import com.majruszsdifficulty.GameDataSaver;
import com.majruszsdifficulty.RegistriesClient;
import com.majruszsdifficulty.blocks.EndShardOre;
import com.majruszsdifficulty.blocks.EnderiumBlock;
import com.majruszsdifficulty.blocks.InfestedEndStone;
import com.majruszsdifficulty.effects.BleedingEffect;
import com.majruszsdifficulty.effects.BleedingImmunityEffect;
import com.majruszsdifficulty.effects.GlassRegenerationEffect;
import com.majruszsdifficulty.entities.CerberusEntity;
import com.majruszsdifficulty.entities.CreeperlingEntity;
import com.majruszsdifficulty.entities.CursedArmorEntity;
import com.majruszsdifficulty.entities.GiantEntity;
import com.majruszsdifficulty.entities.TankEntity;
import com.majruszsdifficulty.features.bleeding.ArmorBleeding;
import com.majruszsdifficulty.features.bleeding.ToolsBleeding;
import com.majruszsdifficulty.items.BandageItem;
import com.majruszsdifficulty.items.CerberusFangItem;
import com.majruszsdifficulty.items.ClothItem;
import com.majruszsdifficulty.items.EndShardItem;
import com.majruszsdifficulty.items.EndShardLocatorItem;
import com.majruszsdifficulty.items.EnderPouchItem;
import com.majruszsdifficulty.items.EnderiumArmorItem;
import com.majruszsdifficulty.items.EnderiumAxeItem;
import com.majruszsdifficulty.items.EnderiumHoeItem;
import com.majruszsdifficulty.items.EnderiumIngotItem;
import com.majruszsdifficulty.items.EnderiumPickaxeItem;
import com.majruszsdifficulty.items.EnderiumShovelItem;
import com.majruszsdifficulty.items.EnderiumSwordItem;
import com.majruszsdifficulty.items.EvokerFangScrollItem;
import com.majruszsdifficulty.items.FakeItem;
import com.majruszsdifficulty.items.GoldenBandageItem;
import com.majruszsdifficulty.items.RecallPotionItem;
import com.majruszsdifficulty.items.SoulJarItem;
import com.majruszsdifficulty.items.TatteredArmorItem;
import com.majruszsdifficulty.items.TreasureBagItem;
import com.majruszsdifficulty.items.UndeadBattleStandardItem;
import com.majruszsdifficulty.items.WitherSwordItem;
import com.majruszsdifficulty.loot.CurseRandomlyFunction;
import com.majruszsdifficulty.treasurebags.TreasureBagManager;
import com.majruszsdifficulty.treasurebags.TreasureBagProgressManager;
import com.majruszsdifficulty.treasurebags.data.LootProgressData;
import com.majruszsdifficulty.triggers.GameStageTrigger;
import com.majruszsdifficulty.triggers.TreasureBagTrigger;
import com.majruszsdifficulty.undeadarmy.UndeadArmyManager;
import com.majruszsdifficulty.world.WorldGenHelper;
import com.mlib.Utility;
import com.mlib.config.ConfigHandler;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.items.CreativeModeTabHelper;
import com.mlib.modhelper.ModHelper;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class Registries {
    public static final ModHelper HELPER = ModHelper.create((String)"majruszsdifficulty");
    public static final ConfigHandler SERVER_CONFIG = HELPER.createConfig(ModConfig.Type.SERVER);
    static final DeferredRegister<Block> BLOCKS;
    static final DeferredRegister<Item> ITEMS;
    static final DeferredRegister<EntityType<?>> ENTITY_TYPES;
    static final DeferredRegister<MobEffect> MOB_EFFECTS;
    static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES;
    static final DeferredRegister<SoundEvent> SOUNDS_EVENTS;
    static final DeferredRegister<LootItemFunctionType> LOOT_FUNCTIONS;
    static final DeferredRegister<Potion> POTIONS;
    static final DeferredRegister<PlacedFeature> PLACED_FEATURES;
    static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES;
    public static final RegistryObject<EntityType<CreeperlingEntity>> CREEPERLING;
    public static final RegistryObject<EntityType<TankEntity>> TANK;
    public static final RegistryObject<EntityType<CursedArmorEntity>> CURSED_ARMOR;
    public static final RegistryObject<EntityType<CerberusEntity>> CERBERUS;
    public static final RegistryObject<EntityType<GiantEntity>> GIANT;
    public static final RegistryObject<BandageItem> BANDAGE;
    public static final RegistryObject<GoldenBandageItem> GOLDEN_BANDAGE;
    public static final RegistryObject<ClothItem> CLOTH;
    public static final RegistryObject<UndeadBattleStandardItem> BATTLE_STANDARD;
    public static final RegistryObject<TatteredArmorItem> TATTERED_HELMET;
    public static final RegistryObject<TatteredArmorItem> TATTERED_CHESTPLATE;
    public static final RegistryObject<TatteredArmorItem> TATTERED_LEGGINGS;
    public static final RegistryObject<TatteredArmorItem> TATTERED_BOOTS;
    public static final RegistryObject<CerberusFangItem> CERBERUS_FANG;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_HELMET;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_CHESTPLATE;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_LEGGINGS;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_BOOTS;
    public static final RegistryObject<EndShardItem> ENDERIUM_SHARD;
    public static final RegistryObject<EnderiumIngotItem> ENDERIUM_INGOT;
    public static final RegistryObject<EnderiumSwordItem> ENDERIUM_SWORD;
    public static final RegistryObject<EnderiumPickaxeItem> ENDERIUM_PICKAXE;
    public static final RegistryObject<EnderiumAxeItem> ENDERIUM_AXE;
    public static final RegistryObject<EnderiumShovelItem> ENDERIUM_SHOVEL;
    public static final RegistryObject<EnderiumHoeItem> ENDERIUM_HOE;
    public static final RegistryObject<EndShardLocatorItem> ENDERIUM_SHARD_LOCATOR;
    public static final RegistryObject<EnderPouchItem> ENDER_POUCH;
    public static final RegistryObject<WitherSwordItem> WITHER_SWORD;
    public static final RegistryObject<RecallPotionItem> RECALL_POTION;
    public static final RegistryObject<EvokerFangScrollItem> EVOKER_FANG_SCROLL;
    public static final RegistryObject<SoulJarItem> SOUL_JAR;
    public static final RegistryObject<Potion> WITHER_POTION;
    public static final RegistryObject<Potion> WITHER_POTION_LONG;
    public static final RegistryObject<Potion> WITHER_POTION_STRONG;
    public static final RegistryObject<TreasureBagItem> UNDEAD_ARMY_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> ELDER_GUARDIAN_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> WITHER_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> ENDER_DRAGON_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> FISHING_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> PILLAGER_TREASURE_BAG;
    public static final RegistryObject<EndShardOre.EndShardOreItem> ENDERIUM_SHARD_ORE_ITEM;
    public static final RegistryObject<EnderiumBlock.EndBlockItem> ENDERIUM_BLOCK_ITEM;
    public static final RegistryObject<InfestedEndStone.InfestedEndStoneItem> INFESTED_END_STONE_ITEM;
    public static final RegistryObject<SpawnEggItem> ILLUSIONER_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> CREEPERLING_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> TANK_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> CURSED_ARMOR_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> CERBERUS_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> GIANT_SPAWN_EGG;
    public static final RegistryObject<EndShardOre> ENDERIUM_SHARD_ORE;
    public static final RegistryObject<EnderiumBlock> ENDERIUM_BLOCK;
    public static final RegistryObject<InfestedEndStone> INFESTED_END_STONE;
    public static final RegistryObject<BleedingEffect> BLEEDING;
    public static final RegistryObject<BleedingImmunityEffect> BLEEDING_IMMUNITY;
    public static final RegistryObject<GlassRegenerationEffect> GLASS_REGENERATION;
    public static final DamageSource BLEEDING_SOURCE;
    public static final RegistryObject<SimpleParticleType> BLOOD;
    public static final CreativeModeTab ITEM_GROUP;
    public static GameDataSaver GAME_DATA_SAVER;
    public static final GameStageTrigger GAME_STATE_TRIGGER;
    public static final TreasureBagTrigger TREASURE_BAG_TRIGGER;
    public static final RegistryObject<SoundEvent> UNDEAD_ARMY_APPROACHING;
    public static final RegistryObject<SoundEvent> UNDEAD_ARMY_WAVE_STARTED;
    public static final RegistryObject<LootItemFunctionType> CURSE_RANDOMLY;
    public static final RegistryObject<ConfiguredFeature<?, ?>> ENDERIUM_ORE_SMALL_CONFIGURED;
    public static final RegistryObject<ConfiguredFeature<?, ?>> ENDERIUM_ORE_LARGE_CONFIGURED;
    public static final RegistryObject<ConfiguredFeature<?, ?>> INFESTED_END_STONE_CONFIGURED;
    public static final RegistryObject<PlacedFeature> ENDERIUM_ORE_SMALL_PLACED;
    public static final RegistryObject<PlacedFeature> ENDERIUM_ORE_LARGE_PLACED;
    public static final RegistryObject<PlacedFeature> INFESTED_END_STONE_PLACED;

    static Supplier<SpawnEggItem> createEggSupplier(Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor) {
        return () -> new ForgeSpawnEggItem(type, backgroundColor, highlightColor, new Item.Properties().m_41491_(ITEM_GROUP));
    }

    static RegistryObject<SoundEvent> register(String name) {
        return SOUNDS_EVENTS.register(name, () -> new SoundEvent(Registries.getLocation(name)));
    }

    public static UndeadArmyManager getUndeadArmyManager() {
        return GAME_DATA_SAVER != null ? GAME_DATA_SAVER.getUndeadArmyManager() : UndeadArmyManager.NOT_LOADED;
    }

    public static TreasureBagProgressManager getTreasureBagProgressManager() {
        return GAME_DATA_SAVER.getTreasureBagProgressManager();
    }

    public static ResourceLocation getLocation(String register) {
        return HELPER.getLocation(register);
    }

    public static String getLocationString(String register) {
        return HELPER.getLocationString(register);
    }

    public static ModelLayerLocation getModelLayer(String register, String layer) {
        return HELPER.getModelLayer(register, layer);
    }

    public static ModelLayerLocation getModelLayer(String register) {
        return HELPER.getModelLayer(register, "main");
    }

    public static RenderType getEyesRenderType(String register) {
        return HELPER.getEyesRenderType(register);
    }

    public static void initialize() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(Registries::setup);
        modEventBus.addListener(Registries::setupClient);
        modEventBus.addListener(Registries::setupEntities);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(Registries::onLoadingLevel);
        forgeEventBus.addListener(Registries::onSavingLevel);
        HELPER.register();
    }

    private static void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(RegistriesClient::setup);
    }

    public static void setupEntities(EntityAttributeCreationEvent event) {
        event.put((EntityType)CREEPERLING.get(), CreeperlingEntity.getAttributeMap());
        event.put((EntityType)TANK.get(), TankEntity.getAttributeMap());
        event.put((EntityType)CURSED_ARMOR.get(), CursedArmorEntity.getAttributeMap());
        event.put((EntityType)CERBERUS.get(), CerberusEntity.getAttributeMap());
        event.put((EntityType)GIANT.get(), GiantEntity.getAttributeMap());
    }

    private static void setup(FMLCommonSetupEvent event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)CREEPERLING.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_21400_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)TANK.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CURSED_ARMOR.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CERBERUS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)GIANT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        event.enqueueWork(() -> {
            Registries.addPotionRecipe(() -> Potions.f_43599_, CERBERUS_FANG, () -> Potions.f_43600_);
            Registries.addPotionRecipe(() -> Potions.f_43602_, CERBERUS_FANG, WITHER_POTION);
            Registries.addPotionRecipe(WITHER_POTION, () -> Items.f_42451_, WITHER_POTION_LONG);
            Registries.addPotionRecipe(WITHER_POTION, () -> Items.f_42525_, WITHER_POTION_STRONG);
        });
    }

    private static void addPotionRecipe(final Supplier<? extends Potion> input, final Supplier<? extends Item> item, final Supplier<? extends Potion> output) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new IBrewingRecipe(){

            public boolean isInput(ItemStack itemStack) {
                return PotionUtils.m_43579_((ItemStack)itemStack).equals(input.get());
            }

            public boolean isIngredient(ItemStack itemStack) {
                return itemStack.m_41720_().equals(item.get());
            }

            public ItemStack getOutput(ItemStack input2, ItemStack ingredient) {
                return this.isInput(input2) && this.isIngredient(ingredient) ? PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)input2.m_41720_()), (Potion)((Potion)output.get())) : ItemStack.f_41583_;
            }
        });
    }

    public static void onLoadingLevel(WorldEvent.Load event) {
        ServerLevel overworld = Registries.getOverworld(event.getWorld());
        if (overworld == null) {
            return;
        }
        GAME_DATA_SAVER = (GameDataSaver)overworld.m_8895_().m_164861_(nbt -> new GameDataSaver(overworld, (CompoundTag)nbt), () -> new GameDataSaver(overworld), "majruszsdifficulty");
        TreasureBagManager.addTreasureBagTo(EntityType.f_20563_, (TreasureBagItem)((Object)ELDER_GUARDIAN_TREASURE_BAG.get()));
        TreasureBagManager.addTreasureBagTo(EntityType.f_20496_, (TreasureBagItem)((Object)WITHER_TREASURE_BAG.get()));
        TreasureBagManager.addTreasureBagTo(EntityType.f_20565_, (TreasureBagItem)((Object)ENDER_DRAGON_TREASURE_BAG.get()));
    }

    public static void onSavingLevel(WorldEvent.Save event) {
        ServerLevel overworld = Registries.getOverworld(event.getWorld());
        if (overworld != null) {
            GAME_DATA_SAVER.m_77762_();
        }
    }

    @Nullable
    private static ServerLevel getOverworld(LevelAccessor levelAccessor) {
        ServerLevel overworld = levelAccessor.m_142572_() != null ? levelAccessor.m_142572_().m_129880_(Level.f_46428_) : null;
        return levelAccessor.equals(overworld) ? overworld : null;
    }

    static {
        ModConfigs.init((ConfigHandler)SERVER_CONFIG, (String)Groups.DEFAULT).name("Features");
        ModConfigs.init((ConfigHandler)SERVER_CONFIG, (String)Groups.UNDEAD_ARMY).name("UndeadArmy");
        ModConfigs.init((ConfigHandler)SERVER_CONFIG, (String)Groups.GAME_STAGE).name("GameStage");
        ModConfigs.init((ConfigHandler)SERVER_CONFIG, (String)Groups.TREASURE_BAG).name("TreasureBag");
        ModConfigs.init((ConfigHandler)SERVER_CONFIG, (String)Groups.MOBS).name("Mobs");
        ModConfigs.init((ConfigHandler)SERVER_CONFIG, (String)Groups.BLEEDING).name("Bleeding");
        BLOCKS = HELPER.create(ForgeRegistries.Keys.BLOCKS);
        ITEMS = HELPER.create(ForgeRegistries.Keys.ITEMS);
        ENTITY_TYPES = HELPER.create(ForgeRegistries.Keys.ENTITY_TYPES);
        MOB_EFFECTS = HELPER.create(ForgeRegistries.Keys.MOB_EFFECTS);
        PARTICLE_TYPES = HELPER.create(ForgeRegistries.Keys.PARTICLE_TYPES);
        SOUNDS_EVENTS = HELPER.create(ForgeRegistries.Keys.SOUND_EVENTS);
        LOOT_FUNCTIONS = HELPER.create(Registry.f_122816_);
        POTIONS = HELPER.create(ForgeRegistries.Keys.POTIONS);
        PLACED_FEATURES = HELPER.create(Registry.f_194567_);
        CONFIGURED_FEATURES = HELPER.create(Registry.f_122881_);
        CREEPERLING = ENTITY_TYPES.register("creeperling", CreeperlingEntity.createSupplier());
        TANK = ENTITY_TYPES.register("tank", TankEntity.createSupplier());
        CURSED_ARMOR = ENTITY_TYPES.register("cursed_armor", CursedArmorEntity.createSupplier());
        CERBERUS = ENTITY_TYPES.register("cerberus", CerberusEntity.createSupplier());
        GIANT = ENTITY_TYPES.register("giant", GiantEntity.createSupplier());
        BANDAGE = ITEMS.register("bandage", BandageItem::new);
        GOLDEN_BANDAGE = ITEMS.register("golden_bandage", GoldenBandageItem::new);
        CLOTH = ITEMS.register("cloth", ClothItem::new);
        BATTLE_STANDARD = ITEMS.register("undead_battle_standard", UndeadBattleStandardItem::new);
        TATTERED_HELMET = ITEMS.register("tattered_helmet", TatteredArmorItem.Helmet::new);
        TATTERED_CHESTPLATE = ITEMS.register("tattered_chestplate", TatteredArmorItem.Chestplate::new);
        TATTERED_LEGGINGS = ITEMS.register("tattered_leggings", TatteredArmorItem.Leggings::new);
        TATTERED_BOOTS = ITEMS.register("tattered_boots", TatteredArmorItem.Boots::new);
        CERBERUS_FANG = ITEMS.register("cerberus_fang", CerberusFangItem::new);
        ENDERIUM_HELMET = ITEMS.register("enderium_helmet", EnderiumArmorItem.Helmet::new);
        ENDERIUM_CHESTPLATE = ITEMS.register("enderium_chestplate", EnderiumArmorItem.Chestplate::new);
        ENDERIUM_LEGGINGS = ITEMS.register("enderium_leggings", EnderiumArmorItem.Leggings::new);
        ENDERIUM_BOOTS = ITEMS.register("enderium_boots", EnderiumArmorItem.Boots::new);
        ENDERIUM_SHARD = ITEMS.register("enderium_shard", EndShardItem::new);
        ENDERIUM_INGOT = ITEMS.register("enderium_ingot", EnderiumIngotItem::new);
        ENDERIUM_SWORD = ITEMS.register("enderium_sword", EnderiumSwordItem::new);
        ENDERIUM_PICKAXE = ITEMS.register("enderium_pickaxe", EnderiumPickaxeItem::new);
        ENDERIUM_AXE = ITEMS.register("enderium_axe", EnderiumAxeItem::new);
        ENDERIUM_SHOVEL = ITEMS.register("enderium_shovel", EnderiumShovelItem::new);
        ENDERIUM_HOE = ITEMS.register("enderium_hoe", EnderiumHoeItem::new);
        ENDERIUM_SHARD_LOCATOR = ITEMS.register("enderium_shard_locator", EndShardLocatorItem::new);
        ENDER_POUCH = ITEMS.register("ender_pouch", EnderPouchItem::new);
        WITHER_SWORD = ITEMS.register("wither_sword", WitherSwordItem::new);
        RECALL_POTION = ITEMS.register("recall_potion", RecallPotionItem::new);
        EVOKER_FANG_SCROLL = ITEMS.register("evoker_fang_scroll", EvokerFangScrollItem::new);
        SOUL_JAR = ITEMS.register("soul_jar", SoulJarItem::new);
        WITHER_POTION = POTIONS.register("wither", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, Utility.secondsToTicks((double)40.0))}));
        WITHER_POTION_LONG = POTIONS.register("long_wither", () -> new Potion("wither", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, Utility.secondsToTicks((double)80.0))}));
        WITHER_POTION_STRONG = POTIONS.register("strong_wither", () -> new Potion("wither", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, Utility.secondsToTicks((double)20.0), 1)}));
        UNDEAD_ARMY_TREASURE_BAG = ITEMS.register("undead_army_treasure_bag", TreasureBagItem.UndeadArmy::new);
        ELDER_GUARDIAN_TREASURE_BAG = ITEMS.register("elder_guardian_treasure_bag", TreasureBagItem.ElderGuardian::new);
        WITHER_TREASURE_BAG = ITEMS.register("wither_treasure_bag", TreasureBagItem.Wither::new);
        ENDER_DRAGON_TREASURE_BAG = ITEMS.register("ender_dragon_treasure_bag", TreasureBagItem.EnderDragon::new);
        FISHING_TREASURE_BAG = ITEMS.register("fishing_treasure_bag", TreasureBagItem.Fishing::new);
        PILLAGER_TREASURE_BAG = ITEMS.register("pillager_treasure_bag", TreasureBagItem.Pillager::new);
        ENDERIUM_SHARD_ORE_ITEM = ITEMS.register("enderium_shard_ore", EndShardOre.EndShardOreItem::new);
        ENDERIUM_BLOCK_ITEM = ITEMS.register("enderium_block", EnderiumBlock.EndBlockItem::new);
        INFESTED_END_STONE_ITEM = ITEMS.register("infested_end_stone", InfestedEndStone.InfestedEndStoneItem::new);
        ILLUSIONER_SPAWN_EGG = ITEMS.register("illusioner_spawn_egg", Registries.createEggSupplier(() -> EntityType.f_20459_, 1268375, 0x959B9B));
        CREEPERLING_SPAWN_EGG = ITEMS.register("creeperling_spawn_egg", Registries.createEggSupplier(CREEPERLING, 894731, 0));
        TANK_SPAWN_EGG = ITEMS.register("tank_spawn_egg", Registries.createEggSupplier(TANK, 0xC1C1C1, 0x949494));
        CURSED_ARMOR_SPAWN_EGG = ITEMS.register("cursed_armor_spawn_egg", Registries.createEggSupplier(CURSED_ARMOR, 0x808080, 0xE1E1E1));
        CERBERUS_SPAWN_EGG = ITEMS.register("cerberus_spawn_egg", Registries.createEggSupplier(CERBERUS, 0x212121, 0xE0E0E0));
        GIANT_SPAWN_EGG = ITEMS.register("giant_spawn_egg", Registries.createEggSupplier(GIANT, 44975, 7969893));
        Stream.of("normal", "expert", "master", "bleeding").forEach(name -> ITEMS.register("advancement_" + name, FakeItem::new));
        ENDERIUM_SHARD_ORE = BLOCKS.register("enderium_shard_ore", EndShardOre::new);
        ENDERIUM_BLOCK = BLOCKS.register("enderium_block", EnderiumBlock::new);
        INFESTED_END_STONE = BLOCKS.register("infested_end_stone", InfestedEndStone::new);
        BLEEDING = MOB_EFFECTS.register("bleeding", BleedingEffect::new);
        BLEEDING_IMMUNITY = MOB_EFFECTS.register("bleeding_immunity", BleedingImmunityEffect::new);
        GLASS_REGENERATION = MOB_EFFECTS.register("glass_regeneration", GlassRegenerationEffect::new);
        BLEEDING_SOURCE = new DamageSource("bleeding").m_19380_();
        BLOOD = PARTICLE_TYPES.register("blood_particle", () -> new SimpleParticleType(true));
        ITEM_GROUP = CreativeModeTabHelper.newTab((String)"majruszsdifficulty.primary", BATTLE_STANDARD);
        GAME_STATE_TRIGGER = (GameStageTrigger)CriteriaTriggers.m_10595_((CriterionTrigger)new GameStageTrigger());
        TREASURE_BAG_TRIGGER = (TreasureBagTrigger)CriteriaTriggers.m_10595_((CriterionTrigger)new TreasureBagTrigger());
        UNDEAD_ARMY_APPROACHING = Registries.register("undead_army.approaching");
        UNDEAD_ARMY_WAVE_STARTED = Registries.register("undead_army.wave_started");
        CURSE_RANDOMLY = LOOT_FUNCTIONS.register("curse_randomly", CurseRandomlyFunction::newType);
        HELPER.createMessage(TankEntity.SkillMessage.class, TankEntity.SkillMessage::new);
        HELPER.createMessage(CursedArmorEntity.AssembleMessage.class, CursedArmorEntity.AssembleMessage::new);
        HELPER.createMessage(LootProgressData.class, LootProgressData::new);
        HELPER.createMessage(BleedingEffect.BloodMessage.class, BleedingEffect.BloodMessage::new);
        HELPER.createMessage(CerberusEntity.SkillMessage.class, CerberusEntity.SkillMessage::new);
        HELPER.createMessage(ToolsBleeding.ToolsDef.class, ToolsBleeding.ToolsDef::new);
        HELPER.createMessage(ArmorBleeding.ArmorsDef.class, ArmorBleeding.ArmorsDef::new);
        HELPER.createMessage(CursedArmorEntity.LocationsDef.class, CursedArmorEntity.LocationsDef::new);
        ENDERIUM_ORE_SMALL_CONFIGURED = CONFIGURED_FEATURES.register("enderium_ore_small", () -> WorldGenHelper.getEndConfigured(ENDERIUM_SHARD_ORE, 2, 0.99f));
        ENDERIUM_ORE_LARGE_CONFIGURED = CONFIGURED_FEATURES.register("enderium_ore_large", () -> WorldGenHelper.getEndConfigured(ENDERIUM_SHARD_ORE, 3, 0.99f));
        INFESTED_END_STONE_CONFIGURED = CONFIGURED_FEATURES.register("infested_end_stone", () -> WorldGenHelper.getEndConfigured(INFESTED_END_STONE, 4, 0.0f));
        ENDERIUM_ORE_SMALL_PLACED = PLACED_FEATURES.register("enderium_ore_small_placed", () -> WorldGenHelper.getEndPlaced(ENDERIUM_ORE_SMALL_CONFIGURED, 16));
        ENDERIUM_ORE_LARGE_PLACED = PLACED_FEATURES.register("enderium_ore_large_placed", () -> WorldGenHelper.getEndPlaced(ENDERIUM_ORE_LARGE_CONFIGURED, 8));
        INFESTED_END_STONE_PLACED = PLACED_FEATURES.register("infested_end_stone_placed", () -> WorldGenHelper.getEndPlaced(INFESTED_END_STONE_CONFIGURED, 128));
    }

    public static class Groups {
        public static final String DEFAULT = Registries.getLocationString("default");
        public static final String UNDEAD_ARMY = Registries.getLocationString("undead_army");
        public static final String GAME_STAGE = Registries.getLocationString("game_stage");
        public static final String TREASURE_BAG = Registries.getLocationString("treasure_bag");
        public static final String MOBS = Registries.getLocationString("mobs");
        public static final String BLEEDING = Registries.getLocationString("bleeding");
    }
}

