/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.viewarea;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ViewArea {
    private static final String NETHER = "minecraft:the_nether";
    private static final String THE_END = "minecraft:the_end";
    private static final float NETHER_EXPAND_FACTOR = 1.1f;
    private static final float THE_END_EXPAND_FACTOR = 1.5f;
    private static final int MAX_BUILD_HEIGHT = 320;
    private static final int MAX_BUILD_HEIGHT_NETHER = 256;
    private static final int MAX_BUILD_HEIGHT_THE_END = 256;
    private static final int MAX_VIEW_AREA_DISTANCE = 240;
    private static final int MIN_BUILD_HEIGHT = -64;
    private String levelName;
    private int posX;
    private int posY;
    private int posZ;
    private int startX;
    private int startY;
    private int startZ;
    private int stopX;
    private int stopY;
    private int stopZ;
    private int viewAreaDistance;
    private int blocksViewDistance;

    public ViewArea(ServerPlayer player, int viewAreaDistance) {
        this(player.m_142538_().m_123341_(), player.m_142538_().m_123342_(), player.m_142538_().m_123343_(), viewAreaDistance, player.f_19853_.m_46472_().m_135782_().toString());
    }

    public ViewArea(int posX, int posY, int posZ, int viewAreaDistance, String levelName) {
        this.update(posX, posY, posZ, viewAreaDistance, levelName);
    }

    public String levelName() {
        return this.levelName;
    }

    public int startX() {
        return this.startX;
    }

    public int stopX() {
        return this.stopX;
    }

    public int startY() {
        return this.startY;
    }

    public int stopY() {
        return this.stopY;
    }

    public int startZ() {
        return this.startZ;
    }

    public int stopZ() {
        return this.stopZ;
    }

    public int blocksViewDistance() {
        return this.blocksViewDistance;
    }

    public boolean isLevel(Level level) {
        return level != null && this.isLevel(level.m_46472_().m_135782_().toString());
    }

    public boolean isLevel(String levelName) {
        return levelName != null && this.levelName.equals(levelName);
    }

    public boolean isInside(Entity entity, String levelName) {
        if (entity == null || entity.m_146910_() || !this.isLevel(levelName)) {
            return false;
        }
        BlockPos blockPos = entity.m_142538_();
        return this.isInside(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public boolean isInside(int posX, int posY, int posZ) {
        return posX >= this.startX && posX <= this.stopX && posY >= this.startY && posY <= this.stopY && posZ >= this.startZ && posZ <= this.stopZ;
    }

    public boolean update(ServerPlayer serverPlayer, int viewAreaDistance) {
        return this.update(serverPlayer.m_142538_().m_123341_(), serverPlayer.m_142538_().m_123342_(), serverPlayer.m_142538_().m_123343_(), viewAreaDistance, serverPlayer.f_19853_.m_46472_().m_135782_().toString());
    }

    public boolean update(ServerPlayer serverPlayer, int viewAreaDistance, String levelName) {
        return this.update(serverPlayer.m_142538_().m_123341_(), serverPlayer.m_142538_().m_123342_(), serverPlayer.m_142538_().m_123343_(), viewAreaDistance, levelName);
    }

    public boolean update(int posX, int posY, int posZ, int viewAreaDistance, String levelName) {
        if (this.posX == posX && this.posY == posY && this.posZ == posZ && this.viewAreaDistance == viewAreaDistance && this.levelName.equals(levelName)) {
            return false;
        }
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.levelName = levelName;
        boolean isNether = levelName.equals(NETHER);
        boolean isTheEnd = levelName.equals(THE_END);
        this.viewAreaDistance = viewAreaDistance;
        if (viewAreaDistance > 240) {
            viewAreaDistance = 240;
        }
        if (isNether) {
            viewAreaDistance = (int)((float)viewAreaDistance * 1.1f);
        } else if (isTheEnd) {
            viewAreaDistance = (int)((float)viewAreaDistance * 1.5f);
        }
        this.blocksViewDistance = viewAreaDistance;
        this.startX = posX - viewAreaDistance;
        this.stopX = posX + viewAreaDistance;
        if (this.levelName.equals(NETHER)) {
            this.startY = Math.max(posY - viewAreaDistance, -64);
            this.stopY = Math.min(posY + viewAreaDistance, 256);
        } else if (this.levelName.equals(THE_END)) {
            this.startY = Math.max(posY - viewAreaDistance, -64);
            this.stopY = Math.min(posY + viewAreaDistance, 256);
        } else {
            this.startY = Math.max(posY - viewAreaDistance, -64);
            this.stopY = Math.min(posY + viewAreaDistance, 320);
        }
        this.startZ = posZ - viewAreaDistance;
        this.stopZ = posZ + viewAreaDistance;
        return true;
    }

    public String toString() {
        return "ViewArea[level='" + this.levelName + "'', pos=(" + this.posX + "," + this.posY + "," + this.posZ + "), start=(" + this.startX + "," + this.startY + "," + this.startZ + "), stop=(" + this.stopX + "," + this.stopY + "," + this.stopZ + "), blockViewDistance=" + this.blocksViewDistance + "]";
    }
}

