/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.server;

import de.markusbordihn.adaptiveperformancetweakscore.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweakscore.server.OptimizationEvent;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLevelLoad;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoad;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.DifficultyChangeEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ServerManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static Random random = new Random();
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static double gameDifficultyFactorEasy = (Double)ServerManager.COMMON.gameDifficultyFactorEasy.get();
    private static double gameDifficultyFactorNormal = (Double)ServerManager.COMMON.gameDifficultyFactorNormal.get();
    private static double gameDifficultyFactorPeaceful = (Double)ServerManager.COMMON.gameDifficultyFactorPeaceful.get();
    private static double gameDifficultyFactorHard = (Double)ServerManager.COMMON.gameDifficultyFactorHard.get();
    private static final int BASE_TICK = 25;
    private static final int OPTIMIZATION_TICK = 100;
    private static final int RESET_TICK = 150;
    private static final int SERVER_LOAD_TICK = 25;
    private static final int WORLD_LOAD_TICK = 50;
    private static int ticks = random.nextInt(15);
    private static MinecraftServer minecraftServer = null;
    private static Iterable<ServerLevel> serverLevels = null;
    private static int maxNumberOfPlayers = 0;
    private static int numberOfPlayers = 0;
    private static Difficulty gameDifficulty = Difficulty.NORMAL;
    private static double gameDifficultyFactor = gameDifficultyFactorNormal;

    protected ServerManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        gameDifficultyFactorEasy = (Double)ServerManager.COMMON.gameDifficultyFactorEasy.get();
        gameDifficultyFactorNormal = (Double)ServerManager.COMMON.gameDifficultyFactorNormal.get();
        gameDifficultyFactorPeaceful = (Double)ServerManager.COMMON.gameDifficultyFactorPeaceful.get();
        gameDifficultyFactorHard = (Double)ServerManager.COMMON.gameDifficultyFactorHard.get();
        log.info("{} Game difficult factors EASY: {}, NORMAL: {}, PEACEFUL: {} and HARD: {}", (Object)"[APTweaks:Core]", (Object)gameDifficultyFactorEasy, (Object)gameDifficultyFactorNormal, (Object)gameDifficultyFactorPeaceful, (Object)gameDifficultyFactorHard);
    }

    @SubscribeEvent
    public static void handleServerStartingEvent(ServerStartingEvent event) {
        maxNumberOfPlayers = ServerManager.getMinecraftServer().m_6846_().m_11310_();
        numberOfPlayers = ServerManager.getMinecraftServer().m_6846_().m_11309_();
        ServerManager.updateGameDifficulty(ServerManager.getMinecraftServer().m_129910_().m_5472_());
        log.info("{} Max number of remote players is set to {}", (Object)"[APTweaks:Core]", (Object)maxNumberOfPlayers);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ServerManager.handleServerTickEvent(Dist.CLIENT);
        } else {
            ++ticks;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void handleDedicatedServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ServerManager.handleServerTickEvent(Dist.DEDICATED_SERVER);
        } else {
            ++ticks;
        }
    }

    @SubscribeEvent
    public static void handleDifficultyChangeEvent(DifficultyChangeEvent event) {
        ServerManager.updateGameDifficulty(event.getDifficulty());
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        numberOfPlayers = ServerManager.getMinecraftServer().m_6846_().m_11309_();
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        numberOfPlayers = ServerManager.getMinecraftServer().m_6846_().m_11309_();
    }

    @SubscribeEvent
    public static void handlePlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        numberOfPlayers = ServerManager.getMinecraftServer().m_6846_().m_11309_();
    }

    public static void handleServerTickEvent(Dist dist) {
        if (ticks == 25) {
            ServerLoad.measureLoadAndPost(dist);
        } else if (ticks == 50) {
            ServerLevelLoad.measureLoadAndPost(dist);
        } else if (ticks == 100) {
            MinecraftForge.EVENT_BUS.post((Event)new OptimizationEvent(dist));
        } else if (ticks >= 150) {
            ticks = 0;
        }
    }

    public static MinecraftServer getMinecraftServer() {
        if (minecraftServer == null) {
            minecraftServer = ServerLifecycleHooks.getCurrentServer();
        }
        return minecraftServer;
    }

    public static long[] getTickTime(ResourceKey<Level> level) {
        return minecraftServer != null ? minecraftServer.getTickTime(level) : null;
    }

    public static double getAverageTickTime(ServerLevel serverLevel) {
        long[] tickTimes = ServerManager.getTickTime((ResourceKey<Level>)serverLevel.m_46472_());
        if (tickTimes != null) {
            return Arrays.stream(tickTimes).average().orElseGet(() -> Double.NaN) / 1000000.0;
        }
        return 0.0;
    }

    public static float getAverageTickTime() {
        return minecraftServer != null ? minecraftServer.m_129903_() : 50.0f;
    }

    public static Iterable<ServerLevel> getAllLevels() {
        if (serverLevels == null) {
            serverLevels = ServerManager.getMinecraftServer().m_129785_();
        }
        return serverLevels;
    }

    public static int getMaxNumberOfPlayers() {
        return maxNumberOfPlayers;
    }

    public static int getNumberOfPlayers() {
        return numberOfPlayers;
    }

    public static Difficulty getGameDifficulty() {
        return gameDifficulty;
    }

    public static double getGameDifficultyFactor() {
        return gameDifficultyFactor;
    }

    private static void updateGameDifficulty(Difficulty difficulty) {
        if (difficulty == gameDifficulty) {
            return;
        }
        gameDifficulty = difficulty;
        switch (difficulty) {
            case EASY: {
                gameDifficultyFactor = gameDifficultyFactorEasy;
                break;
            }
            case NORMAL: {
                gameDifficultyFactor = gameDifficultyFactorNormal;
                break;
            }
            case PEACEFUL: {
                gameDifficultyFactor = gameDifficultyFactorPeaceful;
                break;
            }
            case HARD: {
                gameDifficultyFactor = gameDifficultyFactorHard;
                break;
            }
            default: {
                gameDifficultyFactor = gameDifficultyFactorNormal;
            }
        }
        log.info("{} Game difficulty is set to {} with a {} factor.", (Object)"[APTweaks:Core]", (Object)gameDifficulty, (Object)gameDifficultyFactor);
    }
}

