/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.server;

import de.markusbordihn.adaptiveperformancetweakscore.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoadEvent;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ServerLoad {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static boolean logServerLoad = (Boolean)CommonConfig.COMMON.logServerLoad.get();
    private static int timeBetweenUpdates = (Integer)ServerLoad.COMMON.timeBetweenUpdates.get() * 1000;
    private static long lastUpdateTime = System.currentTimeMillis();
    private static ServerLoadLevel currentServerLoad = ServerLoadLevel.NORMAL;
    private static ServerLoadLevel lastServerLoad = ServerLoadLevel.NORMAL;
    private static double avgTickTime = 50.0;
    private static double lastAvgTickTime = 45.0;

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        logServerLoad = (Boolean)CommonConfig.COMMON.logServerLoad.get();
        timeBetweenUpdates = (Integer)ServerLoad.COMMON.timeBetweenUpdates.get() * 1000;
    }

    public static void measureLoadAndPost(Dist dist) {
        double currentAverageTickTime = ServerManager.getAverageTickTime();
        if (lastAvgTickTime >= currentAverageTickTime && System.currentTimeMillis() - lastUpdateTime < (long)timeBetweenUpdates) {
            return;
        }
        lastAvgTickTime = avgTickTime;
        avgTickTime = ServerManager.getAverageTickTime();
        lastServerLoad = currentServerLoad;
        currentServerLoad = ServerLoad.getServerLoadLevelFromTickTime(avgTickTime);
        if (currentServerLoad != lastServerLoad && logServerLoad) {
            String loadIndicator = lastAvgTickTime > avgTickTime ? "\u2193" : "\u2191";
            log.info("{} {} Server load changed from {} (avg. {}) to {} (avg. {})", (Object)"[APTweaks:Core]", (Object)loadIndicator, (Object)lastServerLoad, (Object)lastAvgTickTime, (Object)currentServerLoad, (Object)avgTickTime);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ServerLoadEvent(currentServerLoad, lastServerLoad, avgTickTime, lastAvgTickTime, dist));
        lastUpdateTime = System.currentTimeMillis();
    }

    public static ServerLoadLevel getServerLoadLevelFromTickTime(double tickTime) {
        if (tickTime <= 20.0) {
            return ServerLoadLevel.VERY_LOW;
        }
        if (tickTime <= 40.0) {
            return ServerLoadLevel.LOW;
        }
        if (tickTime <= 46.0) {
            return ServerLoadLevel.NORMAL;
        }
        if (tickTime <= 49.0) {
            return ServerLoadLevel.MEDIUM;
        }
        if (tickTime <= 55.0) {
            return ServerLoadLevel.HIGH;
        }
        if (tickTime > 55.0) {
            return ServerLoadLevel.VERY_HIGH;
        }
        return ServerLoadLevel.NORMAL;
    }

    public static ServerLoadLevel getServerLoad() {
        return currentServerLoad;
    }

    public static ServerLoadLevel getLastServerLoad() {
        return lastServerLoad;
    }

    public static boolean hasVeryHighServerLoad() {
        return currentServerLoad == ServerLoadLevel.VERY_HIGH;
    }

    public static boolean hasHighServerLoad() {
        return currentServerLoad == ServerLoadLevel.MEDIUM || currentServerLoad == ServerLoadLevel.HIGH || currentServerLoad == ServerLoadLevel.VERY_HIGH;
    }

    public static boolean hasNormalServerLoad() {
        return currentServerLoad == ServerLoadLevel.NORMAL;
    }

    public static boolean hasLowServerLoad() {
        return currentServerLoad == ServerLoadLevel.VERY_LOW || currentServerLoad == ServerLoadLevel.LOW;
    }

    public static double getAvgTickTime() {
        return avgTickTime;
    }

    public static enum ServerLoadLevel {
        VERY_LOW,
        LOW,
        NORMAL,
        MEDIUM,
        HIGH,
        VERY_HIGH;

    }
}

