/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.server;

import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLevelLoad;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.Event;

public class ServerLevelLoadEvent
extends Event {
    private Dist dist;
    private ServerLevel serverLevel;
    private ServerLevelLoad.ServerLevelLoadLevel lastServerLevelLoadLevel = ServerLevelLoad.ServerLevelLoadLevel.NORMAL;
    private ServerLevelLoad.ServerLevelLoadLevel serverLevelLoadLevel = ServerLevelLoad.ServerLevelLoadLevel.NORMAL;
    private String serverLevelName;
    private double serverLevelLoadLevelFactor = 0.0;
    private int playerCount = 0;
    private double avgTickTime = 50.0;
    private double lastAvgTickTime = 45.0;

    public ServerLevelLoadEvent(ServerLevel serverLevel, ServerLevelLoad.ServerLevelLoadLevel serverLevelLoadLevel, ServerLevelLoad.ServerLevelLoadLevel lastServerLevelLoadLevel, double avgTickTime, double lastAvgTickTim, Dist dist) {
        this.avgTickTime = avgTickTime;
        this.dist = dist;
        this.lastAvgTickTime = lastAvgTickTim;
        this.lastServerLevelLoadLevel = lastServerLevelLoadLevel;
        this.playerCount = serverLevel.m_6907_().size();
        this.serverLevel = serverLevel;
        this.serverLevelLoadLevel = serverLevelLoadLevel;
        this.serverLevelName = serverLevel.m_6018_().m_46472_().m_135782_().toString();
    }

    public boolean isDedicatedServer() {
        return this.dist.isDedicatedServer();
    }

    public boolean isClient() {
        return this.dist.isClient();
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    public double getAvgTickTime() {
        return this.avgTickTime;
    }

    public double getLastAvgTickTime() {
        return this.lastAvgTickTime;
    }

    public ServerLevel getServerLevel() {
        return this.serverLevel;
    }

    public String getServerLevelName() {
        return this.serverLevelName;
    }

    public ServerLevelLoad.ServerLevelLoadLevel getServerLevelLoadLevel() {
        return this.serverLevelLoadLevel;
    }

    public double getServerLevelLoadLevelFactor() {
        if (this.serverLevelLoadLevelFactor == 0.0) {
            this.serverLevelLoadLevelFactor = this.calculateServerLevelLoadLevelFactor();
        }
        return this.serverLevelLoadLevelFactor;
    }

    public double calculateServerLevelLoadLevelFactor() {
        if (!(this.serverLevelLoadLevel != ServerLevelLoad.ServerLevelLoadLevel.VERY_LOW && this.serverLevelLoadLevel != ServerLevelLoad.ServerLevelLoadLevel.LOW && this.serverLevelLoadLevel != ServerLevelLoad.ServerLevelLoadLevel.NORMAL || this.lastServerLevelLoadLevel != ServerLevelLoad.ServerLevelLoadLevel.VERY_LOW && this.lastServerLevelLoadLevel != ServerLevelLoad.ServerLevelLoadLevel.LOW && this.lastServerLevelLoadLevel != ServerLevelLoad.ServerLevelLoadLevel.NORMAL)) {
            return 1.0;
        }
        if (this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.NORMAL && this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.MEDIUM) {
            return 0.9;
        }
        if (this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.NORMAL && (this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.HIGH || this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.VERY_HIGH)) {
            return 0.8;
        }
        if (this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.MEDIUM && (this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.MEDIUM || this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.NORMAL || this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.VERY_LOW || this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.LOW)) {
            return 0.7;
        }
        if (this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.MEDIUM && (this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.HIGH || this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.VERY_HIGH)) {
            return 0.6;
        }
        if (this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.HIGH && this.lastServerLevelLoadLevel != ServerLevelLoad.ServerLevelLoadLevel.HIGH && this.lastServerLevelLoadLevel != ServerLevelLoad.ServerLevelLoadLevel.VERY_HIGH) {
            return 0.5;
        }
        if (this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.HIGH) {
            return 0.4;
        }
        if (this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.VERY_HIGH && this.lastServerLevelLoadLevel != ServerLevelLoad.ServerLevelLoadLevel.VERY_HIGH) {
            return 0.3;
        }
        if (this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.VERY_HIGH) {
            return 0.2;
        }
        return 1.0;
    }

    public boolean hasHighServerLevelLoad() {
        return this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.MEDIUM || this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.HIGH || this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.VERY_HIGH || this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.HIGH || this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.VERY_HIGH;
    }

    public boolean hasNormalServerLevelLoad() {
        return this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.NORMAL && (this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.VERY_LOW || this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.LOW || this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.NORMAL);
    }

    public boolean hasLowServerLevelLoad() {
        return this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.VERY_LOW || this.serverLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.LOW && (this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.VERY_LOW || this.lastServerLevelLoadLevel == ServerLevelLoad.ServerLevelLoadLevel.LOW);
    }

    public boolean hasChanged() {
        return this.serverLevelLoadLevel != this.lastServerLevelLoadLevel;
    }
}

