/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.server;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class ServerHandler {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static boolean showedServerAboutToStart = false;
    private static boolean showedServerStartingEvent = false;
    private static boolean showedServerStarted = false;
    private static long serverAboutToStartTime;
    private static long serverStartingTime;
    private static long serverStartedTime;

    protected ServerHandler() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        if (!showedServerAboutToStart) {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            serverAboutToStartTime = System.currentTimeMillis();
            log.info("{} \u23f2 Phase 1/3 - Server took about {} sec to load ...", (Object)"[APTweaks:Core]", (Object)Float.valueOf((float)(serverAboutToStartTime - runtimeMXBean.getStartTime()) / 1000.0f));
            showedServerAboutToStart = true;
        }
    }

    @SubscribeEvent
    public static void handleServerStartingEvent(ServerStartingEvent event) {
        if (!showedServerStartingEvent) {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            serverStartingTime = System.currentTimeMillis();
            log.info("{} \u23f2 Phase 2/3 - Server took about {} sec to starting (\u2206: {} secs)...", (Object)"[APTweaks:Core]", (Object)Float.valueOf((float)(serverStartingTime - runtimeMXBean.getStartTime()) / 1000.0f), (Object)Float.valueOf((float)(serverStartingTime - serverAboutToStartTime) / 1000.0f));
            showedServerStartingEvent = true;
        }
    }

    @SubscribeEvent
    public static void handleServerStartedEvent(ServerStartedEvent event) {
        if (!showedServerStarted) {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            serverStartedTime = System.currentTimeMillis();
            log.info("{} \u23f2 Phase 3/3 - Server took about {} sec to be available and ready to play (\u2206: {} secs) ...", (Object)"[APTweaks:Core]", (Object)Float.valueOf((float)(serverStartedTime - runtimeMXBean.getStartTime()) / 1000.0f), (Object)Float.valueOf((float)(serverStartedTime - serverStartingTime) / 1000.0f));
            showedServerStarted = true;
        }
    }

    public static long getServerAboutToStartTime() {
        return serverAboutToStartTime;
    }

    public static long getServerStartingTime() {
        return serverStartingTime;
    }

    public static long getServerStartedTime() {
        return serverStartedTime;
    }
}

