/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.player;

import de.markusbordihn.adaptiveperformancetweakscore.dimension.DimensionManager;
import de.markusbordihn.adaptiveperformancetweakscore.player.PlayerPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerPositionManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static Random random = new Random();
    private static Map<String, PlayerPosition> playerPositionMap = new ConcurrentHashMap<String, PlayerPosition>();
    private static final int PLAYER_POSITION_UPDATE_TICK = 60;
    private static int updateTicks = random.nextInt(30);
    private static int numberOfPlayers = 0;

    protected PlayerPositionManager() {
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        playerPositionMap = new ConcurrentHashMap<String, PlayerPosition>();
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        String playerUUID = event.getPlayer().m_20149_();
        if (playerUUID != null) {
            log.debug("[Player Position] Removing player {} from position tracking.", (Object)event.getPlayer());
            playerPositionMap.remove(playerUUID);
        }
    }

    @SubscribeEvent
    public static void handleServerTickEventForPositionUpdates(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++updateTicks;
            return;
        }
        if (updateTicks >= 60 && event.haveTime()) {
            PlayerPositionManager.updatePlayerPositions();
            updateTicks = 0;
        }
    }

    private static void updatePlayerPositions() {
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        if (minecraftServer == null) {
            return;
        }
        PlayerList playerList = minecraftServer.m_6846_();
        if (playerList == null) {
            return;
        }
        numberOfPlayers = playerList.m_11309_();
        if (numberOfPlayers == 0) {
            if (!playerPositionMap.isEmpty()) {
                playerPositionMap = new ConcurrentHashMap<String, PlayerPosition>();
            }
            return;
        }
        List serverPlayerList = playerList.m_11314_();
        int viewDistance = playerList.m_11312_();
        int simulationDistance = playerList.m_184213_();
        for (ServerPlayer player : serverPlayerList) {
            if (!player.m_6084_() || player.m_9232_()) continue;
            PlayerPositionManager.updatePlayerPosition(player, viewDistance, simulationDistance);
        }
    }

    public static int getNumberOfPlayers() {
        return numberOfPlayers;
    }

    public static List<PlayerPosition> getPlayerPositionsInsideViewArea(String world, int x, int y, int z) {
        ArrayList<PlayerPosition> playerPositions = new ArrayList<PlayerPosition>();
        for (PlayerPosition playerPosition : playerPositionMap.values()) {
            if (!playerPosition.isInsidePlayerViewArea(world, x, y, z)) continue;
            playerPositions.add(playerPosition);
        }
        return playerPositions;
    }

    public static List<PlayerPosition> getPlayerPositions(String world) {
        ArrayList<PlayerPosition> playerPositions = new ArrayList<PlayerPosition>();
        for (PlayerPosition playerPosition : playerPositionMap.values()) {
            if (!playerPosition.isInsidePlayerViewArea(world)) continue;
            playerPositions.add(playerPosition);
        }
        return playerPositions;
    }

    public static ConcurrentMap<String, List<PlayerPosition>> getPlayerPositions() {
        ConcurrentHashMap<String, List<PlayerPosition>> playerPositions = new ConcurrentHashMap<String, List<PlayerPosition>>();
        List<String> dimensionList = DimensionManager.getDimensionList();
        for (String dimension : dimensionList) {
            List<PlayerPosition> playerPositionsForDimension = PlayerPositionManager.getPlayerPositions(dimension);
            if (playerPositionsForDimension.isEmpty()) continue;
            playerPositions.put(dimension, playerPositionsForDimension);
        }
        return playerPositions;
    }

    public static boolean isInsidePlayersViewArea(String world, int x, int y, int z) {
        for (PlayerPosition playerPosition : playerPositionMap.values()) {
            if (!playerPosition.isInsidePlayerViewArea(world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, PlayerPosition> getPlayerPositionMap() {
        return playerPositionMap;
    }

    private static void updatePlayerPosition(ServerPlayer player, int viewDistance, int simulationDistance) {
        String levelName;
        PlayerPosition playerPosition = playerPositionMap.computeIfAbsent(player.m_20149_(), key -> new PlayerPosition(player, viewDistance, simulationDistance));
        if (playerPosition.update(player, levelName = player.f_19853_.m_46472_().m_135782_().toString(), viewDistance, simulationDistance)) {
            log.debug("[Player Position] Updated position for {} to {}", (Object)player, (Object)playerPosition);
        }
    }
}

