/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.entity;

import de.markusbordihn.adaptiveperformancetweakscore.CoreConstants;
import de.markusbordihn.adaptiveperformancetweakscore.player.PlayerPosition;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class CoreEntityManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static short ticks = 0;
    private static final short VERIFICATION_TICK = 500;
    private static final String ENTITY_OWNER_TAG = "Owner";
    private static ConcurrentHashMap<String, Set<Entity>> entityMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Set<Entity>> entityMapPerChunk = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Set<Entity>> entityMapPerWorld = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Set<Entity>> entityMapGlobal = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> entityChunkMap = new ConcurrentHashMap();

    protected CoreEntityManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        entityMap = new ConcurrentHashMap();
        entityMapPerChunk = new ConcurrentHashMap();
        entityMapPerWorld = new ConcurrentHashMap();
        entityMapGlobal = new ConcurrentHashMap();
    }

    @SubscribeEvent
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ticks = (short)(ticks + 1);
            return;
        }
        if (ticks >= 500 && event.haveTime()) {
            CoreEntityManager.verifyEntities();
            ticks = 0;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        Level level = event.getWorld();
        if (level.f_46443_ || event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!CoreEntityManager.isRelevantEntity(entity)) {
            return;
        }
        String entityName = entity.m_20078_();
        String levelName = level.m_46472_().m_135782_().toString();
        if (entityName == null) {
            String entityType = entity.m_6095_().m_20675_();
            if (log.isDebugEnabled()) {
                if (CoreConstants.ADHOOKS_LOADED && entityType.startsWith("entity.adhooks.") || CoreConstants.COFH_CORE_LOADED && entityType.startsWith("entity.cofh_core.") || CoreConstants.WEATHER_STORMS_TORNADOES_LOADED && entityType.startsWith("entity.weather2.")) {
                    log.debug("[Entity Manager] Ignore modded entity {} in {}", (Object)entity, (Object)levelName);
                } else if (CoreConstants.MANA_AND_ARTIFICE_LOADED && entityType.startsWith("entity.mana-and-artifice.")) {
                    log.debug("[Entity Manager] Ignore {} entity {} in {}", (Object)"Mana and Artifice", (Object)entity, (Object)levelName);
                } else if (entity.isMultipartEntity() || entityType.contains("body_part")) {
                    log.debug("[Entity Manager] Ignore multipart entity {} in {}.", (Object)entity, (Object)levelName);
                } else if (entity.m_8077_()) {
                    Component component = entity.m_7770_();
                    log.debug("[Entity Manager] Unknown entity name for entity {} ({}) with custom name {} in {}.", (Object)entity, (Object)entityType, (Object)(component != null ? component.getString() : ""), (Object)levelName);
                } else {
                    log.warn("[Entity Manager] Unknown entity name for entity {} ({}) in {}. Please report this issue under {}!", (Object)entity, (Object)entityType, (Object)levelName, (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues");
                }
            }
            return;
        }
        CoreEntityManager.addEntity(entity, entityName, levelName);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityLeaveWorldEvent(EntityLeaveWorldEvent event) {
        Level level = event.getWorld();
        if (level.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (!CoreEntityManager.isRelevantEntity(entity)) {
            return;
        }
        String entityName = entity.m_20078_();
        if (entityName == null) {
            return;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        CoreEntityManager.removeEntity(entity, entityName, levelName);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (!CoreEntityManager.isRelevantEntity(entity)) {
            return;
        }
        Level level = entity.m_183503_();
        if (level.f_46443_) {
            return;
        }
        String entityName = entity.m_20078_();
        if (entityName == null) {
            return;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        CoreEntityManager.removeEntity(entity, entityName, levelName);
    }

    public static void addEntity(Entity entity, Level level) {
        String entityName = entity.m_20078_();
        String levelName = level.m_46472_().m_135782_().toString();
        CoreEntityManager.addEntity(entity, entityName, levelName);
    }

    public static void addEntity(Entity entity, String entityName, String levelName) {
        Set entities = entityMap.computeIfAbsent(CoreEntityManager.getEntityMapKey(levelName, entityName), key -> ConcurrentHashMap.newKeySet());
        entities.add(entity);
        String entityChunkKey = CoreEntityManager.getEntityChunkKey(levelName, entity.m_142538_());
        Set entitiesPerChunk = entityMapPerChunk.computeIfAbsent(entityChunkKey, key -> ConcurrentHashMap.newKeySet());
        entitiesPerChunk.add(entity);
        Set entitiesPerWorld = entityMapPerWorld.computeIfAbsent(levelName, key -> ConcurrentHashMap.newKeySet());
        entitiesPerWorld.add(entity);
        Set entitiesGlobal = entityMapGlobal.computeIfAbsent(entityName, key -> ConcurrentHashMap.newKeySet());
        entitiesGlobal.add(entity);
        entityChunkMap.put(entityChunkKey, true);
        log.debug("[Joined] Entity {} ({}) joined {}.", (Object)entityName, (Object)entity, (Object)levelName);
    }

    public static void removeEntity(Entity entity, Level level) {
        String entityName = entity.m_20078_();
        String levelName = level.m_46472_().m_135782_().toString();
        CoreEntityManager.removeEntity(entity, entityName, levelName);
    }

    public static void removeEntity(Entity entity, String entityName, String levelName) {
        Set<Entity> entitiesGlobal;
        Set<Entity> entitiesPerWorld;
        Set<Entity> entitiesPerChunk;
        Set<Entity> entities = entityMap.get(CoreEntityManager.getEntityMapKey(levelName, entityName));
        if (entities != null) {
            entities.remove(entity);
        }
        if ((entitiesPerChunk = entityMapPerChunk.get(CoreEntityManager.getEntityChunkKey(levelName, entity.m_142538_()))) != null) {
            entitiesPerChunk.remove(entity);
        }
        if ((entitiesPerWorld = entityMapPerWorld.get(levelName)) != null) {
            entitiesPerWorld.remove(entity);
        }
        if ((entitiesGlobal = entityMapGlobal.get(levelName)) != null) {
            entitiesGlobal.remove(entity);
        }
        log.debug("[Left] Entity {} ({}) leaved {}.", (Object)entityName, (Object)entity, (Object)levelName);
    }

    public static String getEntityMapKey(String levelName, String entityName) {
        return "[" + levelName + "]" + entityName;
    }

    public static String getEntityChunkKey(String levelName, BlockPos blockPos) {
        return "[" + levelName + ":" + (blockPos.m_123341_() >> 4) + "x" + (blockPos.m_123343_() >> 4) + "]";
    }

    public static Map<String, Set<Entity>> getEntities() {
        return entityMap;
    }

    public static Map<String, Set<Entity>> getEntitiesPerChunk() {
        return entityMapPerChunk;
    }

    public static Map<String, Set<Entity>> getEntitiesPerWorld() {
        return entityMapPerWorld;
    }

    public static Map<String, Set<Entity>> getEntitiesGlobal() {
        return entityMapGlobal;
    }

    public static Map<String, Set<Entity>> getEntities(String dimensionName) {
        ConcurrentHashMap<String, Set<Entity>> entityResultMap = new ConcurrentHashMap<String, Set<Entity>>();
        Set<Map.Entry<String, Set<Entity>>> entities = entityMap.entrySet();
        Iterator<Map.Entry<String, Set<Entity>>> entitiesIterator = entities.iterator();
        String levelName = "[" + dimensionName + "]";
        while (entitiesIterator.hasNext()) {
            Map.Entry<String, Set<Entity>> entity = entitiesIterator.next();
            String key = entity.getKey();
            if (!key.startsWith(levelName)) continue;
            entityResultMap.put(key, entity.getValue());
        }
        return entityResultMap;
    }

    public static Integer getNumberOfEntities(String levelName, String entityName) {
        Set<Entity> entities = entityMap.get(CoreEntityManager.getEntityMapKey(levelName, entityName));
        if (entities == null) {
            return 0;
        }
        return entities.size();
    }

    public static Integer getNumberOfEntitiesPerChunk(String levelName, BlockPos blockPos) {
        Set<Entity> entities = entityMapPerChunk.get(CoreEntityManager.getEntityChunkKey(levelName, blockPos));
        if (entities == null) {
            return 0;
        }
        return entities.size();
    }

    public static Integer getNumberOfEntitiesPerWorld(String levelName) {
        Set<Entity> entities = entityMapPerWorld.get(levelName);
        if (entities == null) {
            return 0;
        }
        return entities.size();
    }

    public static Integer getNumberOfEntities(String entityName) {
        Set<Entity> entities = entityMapGlobal.get(entityName);
        if (entities == null) {
            return 0;
        }
        return entities.size();
    }

    public static Integer getNumberOfEntitiesInPlayerPositions(String levelName, String entityName, List<PlayerPosition> playerPositions) {
        String entityMapKey = CoreEntityManager.getEntityMapKey(levelName, entityName);
        if (!entityMap.containsKey(entityMapKey)) {
            return 0;
        }
        int counter = 0;
        HashSet entities = new HashSet(entityMap.get(entityMapKey));
        for (Entity entity : entities) {
            if (entity == null) continue;
            for (PlayerPosition playerPosition : playerPositions) {
                if (!playerPosition.isInsidePlayerViewArea(entity, levelName)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public static boolean hasEntitySpawnedInChunk(String levelName, BlockPos blockPos) {
        return entityChunkMap.getOrDefault(CoreEntityManager.getEntityChunkKey(levelName, blockPos), false);
    }

    private static void verifyEntities() {
        int removedEntries = 0;
        int removedChunkEntries = 0;
        int removedWorldEntries = 0;
        int removedGlobalEntries = 0;
        if ((removedEntries += CoreEntityManager.removeDiscardedEntities(entityMap)) > 0 || (removedChunkEntries += CoreEntityManager.removeDiscardedEntities(entityMapPerChunk)) > 0 || (removedWorldEntries += CoreEntityManager.removeDiscardedEntities(entityMapPerWorld)) > 0 || (removedGlobalEntries += CoreEntityManager.removeDiscardedEntities(entityMapGlobal)) > 0) {
            log.debug("[Entity Manager] \ud83d\uddd1 Removed {} entities from overview, {} from chunk overview, {} from world overview and {} from global overview.", (Object)removedEntries, (Object)removedChunkEntries, (Object)removedWorldEntries, (Object)removedGlobalEntries);
        }
    }

    private static int removeDiscardedEntities(ConcurrentMap<String, Set<Entity>> entityMapToCheck) {
        int removedEntries = 0;
        if (entityMapToCheck != null && entityMapToCheck.size() > 0) {
            for (Set entities : entityMapToCheck.values()) {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    Entity entity = (Entity)entityIterator.next();
                    if (entity != null && !entity.m_146910_()) continue;
                    entityIterator.remove();
                    ++removedEntries;
                }
            }
        }
        return removedEntries;
    }

    public static boolean isRelevantEntity(Entity entity) {
        Bee bee;
        Mob mob;
        TamableAnimal tamableAnimal;
        Raider raider;
        return !(entity == null || entity.m_146910_() || entity instanceof ExperienceOrb || entity instanceof ItemEntity || entity instanceof LightningBolt || entity instanceof FallingBlockEntity || entity instanceof Projectile || entity instanceof EvokerFangs || entity instanceof EyeOfEnder || entity instanceof MinecartChest || entity instanceof AbstractMinecart || entity instanceof Player || entity instanceof Boat || entity instanceof ArmorStand || entity instanceof AreaEffectCloud || entity instanceof EndCrystal || entity instanceof Marker || entity instanceof HangingEntity || entity instanceof Npc || entity instanceof EnderDragon || entity instanceof EnderDragonPart || entity instanceof WitherBoss || entity instanceof ElderGuardian || entity.m_5833_() || entity.m_20145_() || entity.m_20147_() || entity.m_20160_() || entity.m_20159_() || entity instanceof Raider && (raider = (Raider)entity).m_37886_() || entity instanceof TamableAnimal && ((tamableAnimal = (TamableAnimal)entity).m_142480_() != null || tamableAnimal.m_142504_() != null) || entity instanceof Mob && (mob = (Mob)entity).m_21523_() || entity instanceof Bee && (bee = (Bee)entity).m_27854_() || entity.m_8077_());
    }

    public static boolean isRelevantEntity(Entity entity, String entityName) {
        if (!CoreEntityManager.isRelevantEntity(entity)) {
            return false;
        }
        if (entityName == null) {
            return false;
        }
        if (entityName.startsWith("minecraft:")) {
            return true;
        }
        if (CoreConstants.MANA_AND_ARTIFICE_LOADED && entityName.equals("mana-and-artifice:residual_magic")) {
            return false;
        }
        if (CoreConstants.ARS_NOUVEAU_LOADED && entityName.startsWith("ars_nouveau") || CoreConstants.APPLIED_ENERGISTICS_2_LOADED && entityName.startsWith("ae2") || CoreConstants.BIGGER_REACTORS_LOADED && entityName.startsWith("biggerreactors") || CoreConstants.BOTANIA_LOADED && entityName.startsWith("botania") || CoreConstants.CREATE_LOADED && entityName.startsWith("create") || CoreConstants.EASY_NPC_LOADED && entityName.startsWith("easy_npc") || CoreConstants.FLUX_NETWORKS_LOADED && entityName.startsWith("fluxnetworks") || CoreConstants.GUARD_VILLAGERS_LOADED && entityName.startsWith("guardvillagers") || CoreConstants.HUMAN_COMPANIONS_LOADED && entityName.startsWith("humancompanions") || CoreConstants.INDUSTRIAL_FOREGOING_LOADED && entityName.startsWith("industrialforegoing") || CoreConstants.IMMERSIVE_ENGINEERING_LOADED && entityName.startsWith("immersiveengineering") || CoreConstants.LOOTR_LOADED && entityName.startsWith("lootr") || CoreConstants.MEKANISM_LOADED && entityName.startsWith("mekanism:") || CoreConstants.MODULAR_ROUTERS_LOADED && entityName.startsWith("modularrouters") || CoreConstants.MINECOLONIES_LOADED && entityName.startsWith("minecolonies") || CoreConstants.PIPEZ_LOADED && entityName.startsWith("pipez") || CoreConstants.POKECUBE_AIO_LOADED && entityName.startsWith("pokecube") || CoreConstants.STORAGE_DRAWERS_LOADED && entityName.startsWith("storagedrawers") || CoreConstants.REFINED_STORAGE_LOADED && entityName.startsWith("refinedstorage") || CoreConstants.ULTIMATE_CAR_LOADED && entityName.startsWith("car") || CoreConstants.VIESCRAFT_MACHINES_LOADED && entityName.startsWith("viescraftmachines") || CoreConstants.WEATHER_STORMS_TORNADOES_LOADED && entityName.startsWith("weather2") || CoreConstants.XNET_LOADED && entityName.startsWith("xnet")) {
            return false;
        }
        CompoundTag compoundTag = entity.getPersistentData();
        return !compoundTag.m_128441_(ENTITY_OWNER_TAG) || compoundTag.m_128423_(ENTITY_OWNER_TAG) == null;
    }
}

