/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweakscore.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweakscore.entity.CoreEntityManager;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityCommand
extends CustomCommand {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static final EntityCommand command = new EntityCommand();
    private static final String NO_ENTITIES_TEXT = "Unable to find any entities. Server / World is not loaded?";

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"entities").requires(cs -> cs.m_6761_(2))).executes((Command)command)).then(Commands.m_82127_((String)"overview").executes(command::overview))).then(Commands.m_82127_((String)"overview_per_chunk").executes(command::overviewPerChunk))).then(Commands.m_82127_((String)"overview_per_level").executes(command::overviewPerLevel))).then(Commands.m_82127_((String)"registry").executes(command::registry));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        EntityCommand.sendFeedback(context, "Usage:\n/aptweaks entities overview - List of entities in the world\n/aptweaks entities overview_per_chunk - List of entities per chunk\n/aptweaks entities overview_per_level - List of entities per level\n/aptweaks entities registry - List of known entities from the registry");
        return 0;
    }

    public int overview(CommandContext<CommandSourceStack> context) {
        Map<String, Set<Entity>> entities = CoreEntityManager.getEntitiesGlobal();
        if (entities.isEmpty()) {
            EntityCommand.sendFeedback(context, NO_ENTITIES_TEXT);
            return 0;
        }
        EntityCommand.sendFeedback(context, String.format("Entity overview (%s types)\n===", entities.size()));
        log.info("Entity overview: {}", entities);
        for (Map.Entry<String, Set<Entity>> entity : entities.entrySet()) {
            EntityCommand.sendFeedback(context, String.format("%s x %s", entity.getValue().size(), entity.getKey()));
        }
        return 0;
    }

    public int overviewPerChunk(CommandContext<CommandSourceStack> context) {
        Map<String, Set<Entity>> entities = CoreEntityManager.getEntitiesPerChunk();
        if (entities.isEmpty()) {
            EntityCommand.sendFeedback(context, NO_ENTITIES_TEXT);
            return 0;
        }
        EntityCommand.sendFeedback(context, String.format("Entity overview (%s types)\n===", entities.size()));
        log.info("Entity overview: {}", entities);
        for (Map.Entry<String, Set<Entity>> entity : entities.entrySet()) {
            EntityCommand.sendFeedback(context, String.format("%s x %s", entity.getKey(), entity.getValue().size()));
        }
        return 0;
    }

    public int overviewPerLevel(CommandContext<CommandSourceStack> context) {
        Map<String, Set<Entity>> entities = CoreEntityManager.getEntities();
        if (entities.isEmpty()) {
            EntityCommand.sendFeedback(context, NO_ENTITIES_TEXT);
            return 0;
        }
        EntityCommand.sendFeedback(context, String.format("Entity overview (%s types)\n===", entities.size()));
        log.info("Entity overview: {}", entities);
        for (Map.Entry<String, Set<Entity>> entity : entities.entrySet()) {
            EntityCommand.sendFeedback(context, String.format("%s x %s", entity.getValue().size(), entity.getKey()));
        }
        return 0;
    }

    public int registry(CommandContext<CommandSourceStack> context) {
        Set entitiesKeys = ForgeRegistries.ENTITIES.getKeys();
        if (entitiesKeys.isEmpty()) {
            EntityCommand.sendFeedback(context, NO_ENTITIES_TEXT);
            return 0;
        }
        EntityCommand.sendFeedback(context, String.format("Entity registry (%s types)\n===", entitiesKeys.size()));
        log.info("Entity registry: {}", (Object)entitiesKeys);
        for (ResourceLocation entityKey : entitiesKeys) {
            EntityCommand.sendFeedback(context, String.format("\u25cb %s", entityKey));
        }
        return 0;
    }
}

