/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.client;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TitleScreenHandler {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static boolean showed = false;

    protected TitleScreenHandler() {
    }

    public static void handleInitScreenEvent(ScreenEvent.InitScreenEvent.Post event) {
        if (event.getScreen() instanceof TitleScreen && !showed) {
            log.debug("Found title screen for InitScreenEvent: {}", (Object)event.getScreen());
            TitleScreenHandler.logMessage();
        }
    }

    public static void handleScreenOpenEvent(ScreenOpenEvent event) {
        if (event.getScreen() instanceof TitleScreen && !showed) {
            log.debug("Found title screen for ScreenOpenEvent: {}", (Object)event.getScreen());
            TitleScreenHandler.logMessage();
        }
    }

    public static void logMessage() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        log.info("{} \u23f2 Client took about {} sec to start ...", (Object)"[APTweaks:Core]", (Object)Float.valueOf((float)(System.currentTimeMillis() - runtimeMXBean.getStartTime()) / 1000.0f));
        showed = true;
    }
}

