/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import io.github.flemmli97.tenshilib.client.Color;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class HorizontalColorSlider
extends AbstractWidget {
    private final Color firstColor;
    private final Color secondColor;
    private final Color.MutableColor color;
    private final Consumer<HorizontalColorSlider> onUpdate;

    public HorizontalColorSlider(int x, int y, int width, int height, Color firstColor, Color secondColor, Consumer<HorizontalColorSlider> onUpdate, Component title) {
        super(x, y, width, height, title);
        this.firstColor = firstColor;
        this.secondColor = secondColor;
        this.color = new Color.MutableColor(this.firstColor.hex(), true);
        this.onUpdate = onUpdate;
    }

    public Color getColor() {
        return this.color;
    }

    public void with(int color) {
        Color newColor = new Color(color, false);
        this.color.setRGB(Mth.m_14045_((int)newColor.getRed(), (int)this.firstColor.getRed(), (int)this.secondColor.getRed()), Mth.m_14045_((int)newColor.getGreen(), (int)this.firstColor.getGreen(), (int)this.secondColor.getGreen()), Mth.m_14045_((int)newColor.getBlue(), (int)this.firstColor.getBlue(), (int)this.secondColor.getBlue()), Mth.m_14045_((int)newColor.getAlpha(), (int)this.firstColor.getAlpha(), (int)this.secondColor.getAlpha()));
    }

    public void setColor(int red, int green, int blue, int alpha) {
        int hex = this.color.hex();
        this.color.setRGB(Mth.m_14045_((int)red, (int)this.firstColor.getRed(), (int)this.secondColor.getRed()), Mth.m_14045_((int)green, (int)this.firstColor.getGreen(), (int)this.secondColor.getGreen()), Mth.m_14045_((int)blue, (int)this.firstColor.getBlue(), (int)this.secondColor.getBlue()), Mth.m_14045_((int)alpha, (int)this.firstColor.getAlpha(), (int)this.secondColor.getAlpha()));
        if (hex != this.color.hex()) {
            this.onUpdate.accept(this);
        }
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        HorizontalColorSlider.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (int)(this.f_93620_ + this.f_93618_ + 1), (int)(this.f_93621_ + this.f_93619_ + 1), (int)-1);
        HorizontalColorSlider.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-16777216);
        HorizontalColorSlider.fillHorizontalGradient(poseStack, this.f_93620_, this.f_93621_, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_, this.firstColor.hex(), this.secondColor.hex());
    }

    public void m_5716_(double mouseX, double mouseY) {
        double percent = Mth.m_14008_((double)((mouseX - (double)this.f_93620_) / (double)this.f_93618_), (double)0.0, (double)1.0);
        this.setColor((int)((double)(this.secondColor.getRed() - this.firstColor.getRed()) * percent), (int)((double)(this.secondColor.getGreen() - this.firstColor.getGreen()) * percent), (int)((double)(this.secondColor.getBlue() - this.firstColor.getBlue()) * percent), (int)((double)(this.secondColor.getAlpha() - this.firstColor.getAlpha()) * percent));
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return false;
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        double percent = Mth.m_14008_((double)((mouseX - (double)this.f_93620_) / (double)this.f_93618_), (double)0.0, (double)1.0);
        this.setColor((int)((double)(this.secondColor.getRed() - this.firstColor.getRed()) * percent), (int)((double)(this.secondColor.getGreen() - this.firstColor.getGreen()) * percent), (int)((double)(this.secondColor.getBlue() - this.firstColor.getBlue()) * percent), (int)((double)(this.secondColor.getAlpha() - this.firstColor.getAlpha()) * percent));
        super.m_7212_(mouseX, mouseY, dragX, dragY);
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    protected static void fillHorizontalGradient(PoseStack poseStack, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        HorizontalColorSlider.fillHorizontalGradient(poseStack.m_85850_().m_85861_(), bufferBuilder, x1, y1, x2, y2, colorFrom, colorTo);
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    protected static void fillHorizontalGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float g = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float h = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float i = (float)(colorA & 0xFF) / 255.0f;
        float j = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float k = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float l = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float m = (float)(colorB & 0xFF) / 255.0f;
        builder.m_85982_(matrix, (float)x2, (float)y1, 0.0f).m_85950_(k, l, m, j).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(g, h, i, f).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y2, 0.0f).m_85950_(g, h, i, f).m_5752_();
        builder.m_85982_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(k, l, m, j).m_5752_();
    }
}

