/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.forge.platform.patreon;

import io.github.flemmli97.tenshilib.forge.network.PacketHandler;
import io.github.flemmli97.tenshilib.patreon.PatreonDataManager;
import io.github.flemmli97.tenshilib.patreon.PatreonPlatform;
import io.github.flemmli97.tenshilib.patreon.PatreonPlayerSetting;
import io.github.flemmli97.tenshilib.patreon.pkts.S2CEffectUpdatePkt;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class PatreonImpl
implements PatreonPlatform {
    private static final ResourceLocation capID = new ResourceLocation("tenshilib", "patreon");
    private static final Capability<PatreonPlayerSetting> PATREONPLAYER = CapabilityManager.get((CapabilityToken)new CapabilityToken<PatreonPlayerSetting>(){});

    public static void initPatreonData() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(PatreonImpl::register);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, PatreonImpl::cap);
        MinecraftForge.EVENT_BUS.addListener(PatreonImpl::onLogin);
        MinecraftForge.EVENT_BUS.addListener(PatreonImpl::playerClone);
        MinecraftForge.EVENT_BUS.addListener(PatreonImpl::track);
        PatreonDataManager.init();
    }

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(PatreonPlayerSetting.class);
    }

    public static void cap(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(capID, (ICapabilityProvider)new PlayerCap(player));
        }
    }

    public static void onLogin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PatreonPlatform.INSTANCE.playerSettings((Player)player).ifPresent(setting -> setting.setToDefault(false));
            PatreonPlatform.INSTANCE.sendToClient(player, player);
        }
    }

    public static void playerClone(PlayerEvent.Clone event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean rev = PatreonPlatform.INSTANCE.playerSettings(event.getOriginal()).isPresent();
            if (!rev) {
                event.getOriginal().reviveCaps();
            }
            PatreonPlatform.INSTANCE.playerSettings((Player)serverPlayer).ifPresent(setting -> setting.read(PatreonPlatform.INSTANCE.playerSettings(event.getOriginal()).orElseThrow(() -> new NullPointerException("Capability of old player is null!")).save(new CompoundTag())));
            PatreonPlatform.INSTANCE.sendToClient(serverPlayer, serverPlayer);
            if (!rev) {
                event.getOriginal().invalidateCaps();
            }
        }
    }

    public static void track(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer) {
            ServerPlayer targetPlayer = (ServerPlayer)entity;
            PatreonPlatform.INSTANCE.sendToClient((ServerPlayer)event.getPlayer(), targetPlayer);
        }
    }

    @Override
    public Optional<PatreonPlayerSetting> playerSettings(Player player) {
        return player.getCapability(PATREONPLAYER).resolve();
    }

    @Override
    public void sendToClient(ServerPlayer player, ServerPlayer target) {
        PatreonPlatform.INSTANCE.playerSettings((Player)target).ifPresent(setting -> {
            if (PatreonDataManager.get(target.m_142081_().toString()).tier() < 1) {
                setting.setEffect(null);
            }
            PacketHandler.sendToClientChecked(new S2CEffectUpdatePkt(target.m_142049_(), setting.effect() != null ? setting.effect().id() : "", setting.shouldRender(), setting.getRenderLocation(), setting.getColor()), player);
        });
    }

    @Override
    public void sendToTracking(ServerPlayer player, S2CEffectUpdatePkt pkt) {
        PacketHandler.sendToTracking(pkt, (Entity)player);
    }

    public static class PlayerCap
    extends PatreonPlayerSetting
    implements ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<PatreonPlayerSetting> instance = LazyOptional.of(() -> this);

        public PlayerCap(Player player) {
            super(player);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return PATREONPLAYER.orEmpty(cap, this.instance);
        }

        public CompoundTag serializeNBT() {
            return this.save(new CompoundTag());
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.read(nbt);
        }
    }
}

