/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public abstract class AnimatedAttackGoal<T extends PathfinderMob>
extends Goal {
    protected final T attacker;
    protected LivingEntity target;
    protected AnimatedAction next;
    protected String prevAnim = "";
    protected int idleTime;
    protected int pathFindDelay;
    protected double distanceToTargetSq;
    protected boolean movementDone;

    public AnimatedAttackGoal(T entity) {
        this.attacker = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity living = this.attacker.m_5448_();
        return living != null && living.m_6084_() && this.attacker.m_21444_(living.m_142538_());
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8041_() {
        this.next = null;
        this.target = null;
        this.idleTime = 0;
        this.movementDone = false;
        this.attacker.m_21573_().m_26573_();
        this.attacker.m_21564_(0.0f);
        this.attacker.m_21570_(0.0f);
        this.prevAnim = "";
        this.pathFindDelay = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public abstract AnimatedAction randomAttack();

    public abstract void handlePreAttack();

    public abstract void handleAttack(AnimatedAction var1);

    public abstract void handleIdle();

    public abstract int coolDown(AnimatedAction var1);

    public boolean canChooseAttack(AnimatedAction anim) {
        return anim != null;
    }

    public void setupValues() {
        this.target = this.attacker.m_5448_();
        this.distanceToTargetSq = this.attacker.m_20280_((Entity)this.target);
    }

    public void m_8037_() {
        if (this.attacker.m_5448_() == null) {
            return;
        }
        AnimatedAction anim = ((IAnimated)this.attacker).getAnimationHandler().getAnimation();
        this.setupValues();
        --this.pathFindDelay;
        if (anim != null) {
            this.prevAnim = anim.getID();
            this.handleAttack(anim);
        }
        if (this.next == null && anim == null) {
            AnimatedAction choose;
            if (this.idleTime <= 0 && this.canChooseAttack(choose = this.randomAttack())) {
                this.next = choose;
                this.idleTime = this.coolDown(this.next);
                this.movementDone = false;
            } else {
                this.handleIdle();
                --this.idleTime;
            }
        }
        if (this.next != null) {
            this.handlePreAttack();
            if (this.movementDone) {
                if (anim == null) {
                    ((IAnimated)this.attacker).getAnimationHandler().setAnimation(this.next);
                }
                this.next = null;
            }
        }
    }

    protected void moveRandomlyAround() {
        this.moveRandomlyAround(81.0);
    }

    protected void moveRandomlyAround(double maxDistSq) {
        this.attacker.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (this.distanceToTargetSq <= maxDistSq) {
            Vec3 rand;
            if (this.attacker.m_21573_().m_26571_() && (rand = DefaultRandomPos.m_148403_(this.attacker, (int)5, (int)4)) != null) {
                this.moveTo(rand.f_82479_, rand.f_82480_, rand.f_82481_, 1.0);
            }
        } else {
            this.moveTo((Entity)this.target, 1.0);
        }
    }

    protected void moveToWithDelay(double x, double y, double z, double speed) {
        if (this.pathFindDelay <= 0) {
            if (!this.moveTo(x, y, z, speed)) {
                this.pathFindDelay += 15;
            }
            this.pathFindDelay += this.attacker.m_21187_().nextInt(10) + 5;
        }
    }

    protected void moveToWithDelay(double speed) {
        if (this.pathFindDelay <= 0) {
            if (!this.moveTo((Entity)this.target, speed)) {
                this.pathFindDelay += 15;
            }
            this.pathFindDelay += this.attacker.m_21187_().nextInt(10) + 5;
        }
    }

    private boolean moveTo(double x, double y, double z, double speed) {
        Path path = this.attacker.m_21573_().m_26524_(x, y, z, 0);
        return path != null && this.attacker.m_21573_().m_26536_(path, speed);
    }

    private boolean moveTo(Entity target, double speed) {
        Path path = this.attacker.m_21573_().m_6570_(target, 0);
        return path != null && this.attacker.m_21573_().m_26536_(path, speed);
    }

    protected BlockPos randomPosAwayFrom(LivingEntity away, float minDis) {
        double angle = Math.random() * Math.PI * 2.0;
        double x = Math.cos(angle) * (double)minDis;
        double z = Math.sin(angle) * (double)minDis;
        float min = minDis * minDis;
        BlockPos pos = this.attacker.m_142538_().m_142022_(x, 0.0, z);
        if (away.m_20238_(Vec3.m_82512_((Vec3i)pos)) > (double)min && this.attacker.m_21444_(pos)) {
            return pos;
        }
        return this.attacker.m_142538_();
    }

    protected void circleAround(double posX, double posZ, float radius, boolean clockWise, float speed) {
        double z;
        double x = this.attacker.m_20185_() - posX;
        double r = x * x + (z = this.attacker.m_20189_() - posZ) * z;
        if (r < ((double)radius - 1.5) * ((double)radius - 1.5) || r > ((double)radius + 1.5) * ((double)radius + 1.5)) {
            double[] c = MathUtils.closestOnCircle(posX, posZ, this.attacker.m_20185_(), this.attacker.m_20189_(), radius);
            this.attacker.m_21573_().m_26519_(c[0], this.attacker.m_20186_(), c[1], (double)speed);
        } else {
            double angle = MathUtils.phiFromPoint(posX, posZ, this.attacker.m_20185_(), this.attacker.m_20189_()) + (double)(clockWise ? MathUtils.degToRad(15.0f) : -MathUtils.degToRad(15.0f));
            double nPosX = (double)radius * Math.cos(angle);
            double nPosZ = (double)radius * Math.sin(angle);
            this.attacker.m_21573_().m_26519_(posX + nPosX, this.attacker.m_20186_(), posZ + nPosZ, (double)speed);
        }
    }

    protected void circleAroundTargetFacing(float radius, boolean clockWise, float speed) {
        this.attacker.m_21391_((Entity)this.target, 30.0f, 30.0f);
        double x = this.attacker.m_20185_() - this.target.m_20185_();
        double z = this.attacker.m_20189_() - this.target.m_20189_();
        double r = x * x + z * z;
        this.attacker.m_21566_().m_24988_(r < ((double)radius - 1.5) * ((double)radius - 1.5) ? -0.5f : (r > ((double)radius + 1.5) * ((double)radius + 1.5) ? 0.5f : 0.0f), clockWise ? speed : -speed);
    }

    protected void teleportAround(double posX, double posY, double posZ, int range) {
        double x = posX + (this.attacker.m_21187_().nextDouble() - 0.5) * (double)range * 2.0;
        double y = posY + (double)this.attacker.m_21187_().nextInt(3);
        double z = posZ + (this.attacker.m_21187_().nextDouble() - 0.5) * (double)range * 2.0;
        this.attacker.m_20984_(x, y, z, false);
    }
}

