/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.config;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.common.config.JsonConfig;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;

public class CommentedJsonConfig {
    private final Map<String, CommentedVal<?>> configVals;
    public final Map<String, List<String>> categoryComments;
    private final Runnable reloadHandler;
    private final int confVersion;

    private CommentedJsonConfig(int version, Runnable reloadHandler, Map<String, CommentedVal<?>> map, Map<String, List<String>> categoryComments) {
        this.confVersion = version;
        this.configVals = map;
        this.categoryComments = categoryComments;
        this.reloadHandler = reloadHandler;
    }

    public JsonObject serialize(Gson gson) {
        JsonObject obj = new JsonObject();
        obj.addProperty("version", (Number)this.confVersion);
        this.configVals.forEach((key, val) -> {
            JsonObject vO = new JsonObject();
            vO.add("__comment", gson.toJsonTree(val.__comments));
            vO.add("input", gson.toJsonTree(val.input));
            obj.add(key, (JsonElement)vO);
        });
        return obj;
    }

    public Set<String> deserialize(JsonObject object, Gson gson) {
        HashSet<String> faulty = new HashSet<String>();
        int version = GsonHelper.m_13824_((JsonObject)object, (String)"version", (int)0);
        if (version < this.confVersion) {
            faulty.add("Config Version");
        }
        for (Map.Entry<String, CommentedVal<?>> e : this.configVals.entrySet()) {
            if (!object.has(e.getKey())) continue;
            CommentedVal<?> val = e.getValue();
            try {
                Object v = gson.fromJson(object.get(e.getKey()).getAsJsonObject().get("input"), val.getInputClass());
                if (v == null && !val.allowNullValue) {
                    throw new JsonSyntaxException("Value was null for " + e.getKey());
                }
                val.set(v);
            }
            catch (JsonSyntaxException | IllegalStateException ex) {
                faulty.add(e.getKey());
            }
        }
        return faulty;
    }

    public Map<String, CommentedVal<?>> getConfigVals() {
        return ImmutableMap.copyOf(this.configVals);
    }

    public void onReload() {
        this.reloadHandler.run();
    }

    public static class CommentedVal<T> {
        protected final List<String> __comments;
        protected T input;
        protected final T defaultVal;
        protected final boolean allowNullValue;

        private CommentedVal(List<String> comments, T input, boolean allowNullValue) {
            this.__comments = comments;
            this.input = input;
            this.defaultVal = input;
            this.allowNullValue = allowNullValue;
        }

        public T get() {
            return this.input;
        }

        public void set(T value) {
            this.input = value;
        }

        public Class<?> getInputClass() {
            return this.input.getClass();
        }
    }

    public static class Builder {
        private List<String> comments;
        private final Map<String, CommentedVal<?>> conf = new LinkedHashMap();
        private String path = "";
        private final Map<String, List<String>> categoryComments = new LinkedHashMap<String, List<String>>();
        private Runnable reloadHandler = () -> {};

        public Builder comment(String ... comments) {
            ArrayList<String> list = new ArrayList<String>();
            for (String s : comments) {
                String[] split = s.split("\n");
                list.addAll(Arrays.asList(split));
            }
            this.comments = list;
            return this;
        }

        public Builder push(String path) {
            this.path = this.path.isEmpty() ? path : this.path + "." + path;
            if (this.comments != null) {
                this.categoryComments.put(this.path, this.comments);
            }
            this.comments = null;
            return this;
        }

        public Builder pop() {
            if (this.path.isEmpty()) {
                TenshiLib.logger.error("Tried to pop config with empty path!");
                return this;
            }
            int i = this.path.lastIndexOf(".");
            this.path = i > 0 ? this.path.substring(0, i) : "";
            return this;
        }

        public <T> CommentedVal<T> define(String name, T value) {
            return this.define(name, value, value == null);
        }

        public <T> CommentedVal<T> define(String name, T value, boolean allowNullValue) {
            if (value instanceof List) {
                List v2 = (List)value;
                return this.defineList(name, v2, s -> true);
            }
            if (value.getClass().isEnum()) {
                ?[] vals = value.getClass().getEnumConstants();
                ArrayList<String> comment = this.comments != null ? this.comments : new ArrayList<String>();
                comment.add("Allowed Values: " + Arrays.stream(vals).map(v -> ((Enum)v).name()).collect(Collectors.joining(", ")));
                return this.define(name, new CommentedVal<T>(comment, value, allowNullValue));
            }
            return this.define(name, new CommentedVal<T>(this.comments, value, allowNullValue));
        }

        public <T> CommentedVal<List<T>> defineList(String name, List<T> value, Predicate<T> validator) {
            return this.define(name, new ListVal<T>(this.comments, value, validator));
        }

        private <C, T extends CommentedVal<C>> T define(String name, T val) {
            if (!this.path.isEmpty()) {
                name = this.path + "." + (String)name;
            }
            this.conf.put((String)name, val);
            this.comments = null;
            return val;
        }

        public IntVal defineInRange(String name, int value, int min, int max) {
            ArrayList<String> comment;
            ArrayList<String> arrayList = comment = this.comments != null ? this.comments : new ArrayList<String>();
            if (max != Integer.MAX_VALUE || min != Integer.MIN_VALUE) {
                if (Integer.MAX_VALUE == max) {
                    comment.add("Range: > " + min);
                } else if (Integer.MIN_VALUE == min) {
                    comment.add("Range: < " + max);
                } else {
                    comment.add("Range: " + min + " ~ " + max);
                }
            }
            return this.define(name, new IntVal(comment, value, min, max));
        }

        public DoubleVal defineInRange(String name, double value, double min, double max) {
            ArrayList<String> comment;
            ArrayList<String> arrayList = comment = this.comments != null ? this.comments : new ArrayList<String>();
            if (max != Double.MAX_VALUE || min != Double.MIN_VALUE) {
                if (Double.MAX_VALUE == max) {
                    comment.add("Range: > " + min);
                } else if (Double.MIN_VALUE == min) {
                    comment.add("Range: < " + max);
                } else {
                    comment.add("Range: " + min + " ~ " + max);
                }
            }
            return this.define(name, new DoubleVal(comment, value, min, max));
        }

        public Builder registerReloadHandler(Runnable run) {
            this.reloadHandler = run;
            return this;
        }

        public static <C> Pair<JsonConfig<CommentedJsonConfig>, C> create(Path file, int version, Function<Builder, C> cons) {
            Builder builder = new Builder();
            C c = cons.apply(builder);
            return Pair.of(new JsonConfig<CommentedJsonConfig>(file, CommentedJsonConfig.class, new CommentedJsonConfig(version, builder.reloadHandler, builder.conf, (Map<String, List<String>>)ImmutableMap.copyOf(builder.categoryComments))), c);
        }
    }

    public static class ListVal<T>
    extends CommentedVal<List<T>> {
        protected final Predicate<T> validator;

        private ListVal(List<String> comments, List<T> input, Predicate<T> test) {
            super(comments, input, false);
            this.validator = test;
        }

        @Override
        public Class<?> getInputClass() {
            return List.class;
        }
    }

    public static class DoubleVal
    extends CommentedVal<Double> {
        protected final transient double min;
        protected final transient double max;

        private DoubleVal(List<String> comments, double input, double min, double max) {
            super(comments, input, false);
            this.min = min;
            this.max = max;
        }

        @Override
        public Double get() {
            return Mth.m_14008_((double)((Double)this.input), (double)this.min, (double)this.max);
        }
    }

    public static class IntVal
    extends CommentedVal<Integer> {
        protected final transient int min;
        protected final transient int max;

        private IntVal(List<String> comments, int input, int min, int max) {
            super(comments, input, false);
            this.min = min;
            this.max = max;
        }

        @Override
        public Integer get() {
            return Mth.m_14045_((int)((Integer)this.input), (int)this.min, (int)this.max);
        }
    }
}

