/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.github.flemmli97.tenshilib.client.ClientHandlers;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;

public class RiderLayerRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final EntityRenderDispatcher dispatcher;
    private final LivingEntityRenderer<T, M> renderer;

    public RiderLayerRenderer(LivingEntityRenderer<T, M> renderer) {
        super(renderer);
        this.renderer = renderer;
        this.dispatcher = Minecraft.m_91087_().m_91290_();
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < entity.m_20197_().size(); ++i) {
            Entity rider = (Entity)entity.m_20197_().get(i);
            if (rider == null || Minecraft.m_91087_().f_91075_ == rider && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) continue;
            ClientHandlers.RIDING_RENDER_BLACKLIST.add(rider.m_142081_());
            stack.m_85836_();
            EntityRenderer entityRenderer = this.dispatcher.m_114382_(rider);
            boolean transformed = ((RideableModel)this.m_117386_()).transform(entity, this.renderer, rider, (EntityRenderer<?>)entityRenderer, stack, i);
            this.renderPassenger(entity, entityRenderer, rider, partialTicks, stack, buffer, light, transformed);
            stack.m_85849_();
            ClientHandlers.RIDING_RENDER_BLACKLIST.remove(rider.m_142081_());
        }
    }

    protected void undoLivingRendererTransform(EntityRenderer<?> entityRenderer, PoseStack stack, T entity, Entity rider, float partialTicks, boolean transformed) {
        float yaw = Mth.m_14189_((float)partialTicks, (float)((LivingEntity)entity).f_20884_, (float)((LivingEntity)entity).f_20883_);
        if (rider instanceof LivingEntity) {
            LivingEntity livingRider = (LivingEntity)rider;
            float headRot = Mth.m_14189_((float)partialTicks, (float)livingRider.f_20886_, (float)livingRider.f_20885_);
            float diff = Mth.m_14177_((float)(headRot - yaw));
            if (diff < -85.0f) {
                diff = -85.0f;
            }
            if (diff >= 85.0f) {
                diff = 85.0f;
            }
            yaw = headRot - diff;
            if (diff * diff > 2500.0f) {
                yaw += diff * 0.2f;
            }
        }
        if (!transformed) {
            stack.m_85837_(0.0, (double)1.501f, 0.0);
        }
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_85845_(Vector3f.f_122225_.m_122240_(yaw + 180.0f));
    }

    public <E extends Entity> void renderPassenger(T vehicle, EntityRenderer<E> entityRenderer, E entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight, boolean transformed) {
        try {
            this.undoLivingRendererTransform(entityRenderer, stack, vehicle, entity, partialTicks, transformed);
            if (!transformed) {
                Vec3 diff = entity.m_20182_().m_82546_(vehicle.m_20182_());
                stack.m_85837_(diff.f_82479_, diff.f_82480_, diff.f_82481_);
            }
            entityRenderer.m_7392_(entity, 0.0f, partialTicks, stack, buffer, packedLight);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)("Rendering entity in world from " + ((Object)((Object)this)).getClass()));
            CrashReportCategory crashReportCategory = crashReport.m_127514_("Entity being rendered");
            entity.m_7976_(crashReportCategory);
            CrashReportCategory crashReportCategory2 = crashReport.m_127514_("Renderer details");
            crashReportCategory2.m_128159_("Assigned renderer", entityRenderer);
            crashReportCategory2.m_128159_("Location", (Object)CrashReportCategory.m_178937_((LevelHeightAccessor)entity.f_19853_, (double)entity.m_20182_().f_82479_, (double)entity.m_20182_().f_82480_, (double)entity.m_20182_().f_82481_));
            crashReportCategory2.m_128159_("Delta", (Object)Float.valueOf(partialTicks));
            throw new ReportedException(crashReport);
        }
    }
}

