/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.particles;

import io.github.flemmli97.tenshilib.client.particles.ParticleRenderTypes;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;

public class ColoredParticle
extends TextureSheetParticle {
    public final SpriteSet spriteProvider;
    protected boolean randomMovements;
    protected boolean gravity;

    public ColoredParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, ColoredParticleData colorData, SpriteSet sprite, int maxAge, float minAgeRand, float maxAgeRand, boolean collide, boolean randomMovements, boolean gravity) {
        super(world, x, y, z);
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.m_107253_(colorData.getRed(), colorData.getGreen(), colorData.getBlue());
        this.m_107271_(colorData.getAlpha());
        float mult = Mth.m_14068_((Random)world.f_46441_, (float)minAgeRand, (float)maxAgeRand);
        this.f_107225_ = (int)((float)maxAge * mult);
        this.spriteProvider = sprite;
        this.m_108339_(this.spriteProvider);
        this.f_107663_ *= colorData.getScale();
        this.f_107219_ = collide;
        this.randomMovements = randomMovements;
        this.gravity = gravity;
    }

    public ColoredParticle setScale(float scale) {
        this.f_107663_ = scale;
        return this;
    }

    public float m_5902_(float partialTicks) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + partialTicks) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderTypes.TRANSLUCENTADD;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.spriteProvider);
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (this.randomMovements) {
                if (this.f_107213_ == this.f_107210_) {
                    this.f_107215_ *= 1.1;
                    this.f_107217_ *= 1.1;
                }
                this.f_107215_ *= (double)0.96f;
                this.f_107216_ *= (double)0.96f;
                this.f_107217_ *= (double)0.96f;
                if (this.f_107218_) {
                    this.f_107215_ *= (double)0.7f;
                    this.f_107217_ *= (double)0.7f;
                }
            }
            if (this.gravity) {
                this.f_107216_ = this.gravity();
                this.f_107216_ = Math.max(this.f_107216_, (double)this.maxGravity());
            }
        }
    }

    protected float gravity() {
        return -0.009f;
    }

    protected float maxGravity() {
        return -0.1f;
    }

    public static class NoGravityParticleFactory
    implements ParticleProvider<ColoredParticleData> {
        private final SpriteSet sprite;

        public NoGravityParticleFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(ColoredParticleData data, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new ColoredParticle(world, x, y, z, motionX, motionY, motionZ, data, this.sprite, 20, 1.0f, 1.0f, false, false, false).setScale(data.getScale());
        }
    }

    public static class LightParticleFactory
    implements ParticleProvider<ColoredParticleData> {
        private final SpriteSet sprite;

        public LightParticleFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(ColoredParticleData data, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new ColoredParticle(world, x, y, z, motionX, motionY, motionZ, data, this.sprite, 40, 0.7f, 1.3f, false, true, false);
        }
    }
}

