/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.entity;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class AnimationHandler<T extends Entity> {
    public static final int DEFAULT_ADJUST_TIME = 3;
    private AnimatedAction currentAnim;
    private AnimatedAction lastAnim;
    private final T entity;
    private final AnimatedAction[] anims;
    private Predicate<AnimatedAction> onAnimationSetFunc;
    private Consumer<AnimatedAction> onAnimationSetCons;
    private Consumer<AnimatedAction> onRunAnimation;
    private ToFloatFunction<AnimatedAction> animationSpeedHandler;
    private int timeSinceLastChange;

    public AnimationHandler(T entity, AnimatedAction[] anims) {
        this.entity = entity;
        Objects.requireNonNull(anims);
        this.anims = anims;
    }

    public AnimationHandler<T> setAnimationChangeFunc(Predicate<AnimatedAction> onAnimationSet) {
        this.onAnimationSetFunc = onAnimationSet;
        return this;
    }

    public AnimationHandler<T> setAnimationChangeCons(Consumer<AnimatedAction> onAnimationSetCons) {
        this.onAnimationSetCons = onAnimationSetCons;
        return this;
    }

    public AnimationHandler<T> addActionHandle(Consumer<AnimatedAction> handleAction) {
        this.onRunAnimation = handleAction;
        return this;
    }

    public AnimationHandler<T> setAnimationSpeedHandler(ToFloatFunction<AnimatedAction> animationSpeedHandler) {
        this.animationSpeedHandler = animationSpeedHandler;
        return this;
    }

    @Nullable
    public AnimatedAction getAnimation() {
        return this.currentAnim;
    }

    public void runIfAnimation(String id, Consumer<AnimatedAction> anim) {
        if (this.isCurrent(id)) {
            anim.accept(this.getAnimation());
        }
    }

    public void runIfNotNull(Consumer<AnimatedAction> cons) {
        if (this.currentAnim != null) {
            cons.accept(this.currentAnim);
        }
    }

    public boolean hasAnimation() {
        return this.currentAnim != null;
    }

    public void setAnimation(AnimatedAction anim) {
        if (this.onAnimationSetCons != null) {
            this.onAnimationSetCons.accept(anim);
        }
        if (this.onAnimationSetFunc != null && this.onAnimationSetFunc.test(anim)) {
            return;
        }
        this.lastAnim = this.currentAnim;
        this.timeSinceLastChange = 0;
        AnimatedAction animatedAction = anim == null ? null : (this.currentAnim = anim.create(this.animationSpeedHandler == null ? anim.getSpeed() : this.animationSpeedHandler.m_183321_((Object)anim)));
        if (!((Entity)this.entity).f_19853_.f_46443_) {
            EventCalls.INSTANCE.sendEntityAnimationPacket(this.entity);
        }
    }

    public AnimatedAction[] getAnimations() {
        return this.anims;
    }

    public boolean isCurrent(AnimatedAction ... anims) {
        for (AnimatedAction action : anims) {
            if (!action.is(this.getAnimation())) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrent(String ... ids) {
        if (!this.hasAnimation()) {
            return false;
        }
        for (String id : ids) {
            if (!this.getAnimation().getID().equals(id)) continue;
            return true;
        }
        return false;
    }

    public int getTimeSinceLastChange() {
        return this.timeSinceLastChange;
    }

    public AnimatedAction getLastAnim() {
        return this.lastAnim;
    }

    public void tick() {
        if (this.hasAnimation()) {
            if (this.getAnimation().tick()) {
                this.setAnimation(null);
            } else if (this.onRunAnimation != null) {
                this.onRunAnimation.accept(this.getAnimation());
            }
        }
        ++this.timeSinceLastChange;
    }

    public void finishAnimation() {
        AnimatedAction anim = this.getAnimation();
        if (anim != null) {
            while (anim.getTick() < anim.getLength()) {
                anim.tick();
            }
            if (anim.shouldRunOut()) {
                this.setAnimation(null);
            } else {
                this.timeSinceLastChange = anim.getLength();
            }
        }
    }

    public float getInterpolatedAnimationVal(float partialTicks) {
        return this.getInterpolatedAnimationVal(partialTicks, 3.0f);
    }

    public float getInterpolatedAnimationVal(float partialTicks, float adjustTime) {
        return Mth.m_14036_((float)(((float)this.getTimeSinceLastChange() + partialTicks) / adjustTime), (float)0.0f, (float)1.0f);
    }
}

