/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.idas.state;

import com.craisinlord.idas.IDAS;
import com.craisinlord.idas.state.stateRegion;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

public class stateCache {
    public ConcurrentHashMap<String, stateRegion> sateRegionMap = new ConcurrentHashMap();
    private final Path savePath;

    public stateCache(Path dimensionPath) {
        this.savePath = dimensionPath.resolve("idas");
        this.createDirectoryIfDoesNotExist();
    }

    public boolean isCleared(BlockPos pos) {
        String regionKey = this.getRegionKey(pos);
        stateRegion stateRegion2 = this.sateRegionMap.computeIfAbsent(regionKey, key -> new stateRegion(this.savePath, (String)key));
        return stateRegion2.isCleared(pos);
    }

    public void setCleared(BlockPos pos, boolean isCleared) {
        String regionKey = this.getRegionKey(pos);
        stateRegion stateRegion2 = this.sateRegionMap.computeIfAbsent(regionKey, key -> new stateRegion(this.savePath, (String)key));
        stateRegion2.setCleared(pos, isCleared);
    }

    private String getRegionKey(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        return "r." + chunkPos.m_45610_() + "." + chunkPos.m_45612_() + ".labyrinths";
    }

    private void createDirectoryIfDoesNotExist() {
        try {
            Files.createDirectories(this.savePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            IDAS.LOGGER.error("Unable to create Labyrinths save path {}", (Object)this.savePath);
            IDAS.LOGGER.error((Object)e);
        }
    }
}

