/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockToolSwapUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class BlockToolSwapMessage {
    private final BlockPos pos;

    public BlockToolSwapMessage(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(BlockToolSwapMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeLong(msg.pos.m_121878_());
    }

    public static BlockToolSwapMessage decode(FriendlyByteBuf packetBuffer) {
        return new BlockToolSwapMessage(BlockPos.m_122022_((long)packetBuffer.readLong()));
    }

    static void onMessage(BlockToolSwapMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> BlockToolSwapMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(BlockToolSwapMessage msg, @Nullable ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        AtomicBoolean anyUpgradeCanInteract = new AtomicBoolean(false);
        PlayerInventoryProvider.get().runOnBackpacks((Player)sender, (backpack, inventoryName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(backpackWrapper -> {
            backpackWrapper.getUpgradeHandler().getWrappersThatImplement(IBlockToolSwapUpgrade.class).forEach(upgrade -> {
                if (!upgrade.canProcessBlockInteract() || result.get()) {
                    return;
                }
                anyUpgradeCanInteract.set(true);
                result.set(upgrade.onBlockInteract(sender.f_19853_, msg.pos, sender.f_19853_.m_8055_(msg.pos), (Player)sender));
            });
            return result.get();
        }).orElse(false));
        if (!anyUpgradeCanInteract.get()) {
            sender.m_5661_((Component)new TranslatableComponent("gui.sophisticatedbackpacks.status.no_tool_swap_upgrade_present"), true);
            return;
        }
        if (!result.get()) {
            sender.m_5661_((Component)new TranslatableComponent("gui.sophisticatedbackpacks.status.no_tool_found_for_block"), true);
        }
    }
}

