/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;

public class BackpackDynamicModel
implements IModelGeometry<BackpackDynamicModel> {
    private final Map<ModelPart, UnbakedModel> modelParts;

    public BackpackDynamicModel(Map<ModelPart, UnbakedModel> modelParts) {
        this.modelParts = modelParts;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.modelParts.forEach((part, model) -> {
            BakedModel bakedModel = model.m_7611_(bakery, spriteGetter, modelTransform, modelLocation);
            if (bakedModel != null) {
                builder.put((Object)part, (Object)bakedModel);
            }
        });
        return new BackpackBakedModel((Map<ModelPart, BakedModel>)builder.build(), modelTransform);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.modelParts.forEach((part, model) -> builder.addAll((Iterable)model.m_5500_(modelGetter, missingTextureErrors)));
        return builder.build();
    }

    private static final class BackpackBakedModel
    implements IDynamicBakedModel {
        private static final Map<ItemTransforms.TransformType, Transformation> TRANSFORMS;
        private static final ItemTransforms ITEM_TRANSFORMS;
        private static final ResourceLocation BACKPACK_MODULES_TEXTURE;
        private final BackpackItemOverrideList overrideList = new BackpackItemOverrideList(this);
        private final Map<ModelPart, BakedModel> models;
        private final ModelState modelTransform;
        private boolean tankLeft;
        @Nullable
        private IRenderedTankUpgrade.TankRenderInfo leftTankRenderInfo = null;
        private boolean tankRight;
        @Nullable
        private IRenderedTankUpgrade.TankRenderInfo rightTankRenderInfo = null;
        private boolean battery;
        @Nullable
        private IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;

        private static ItemTransforms createItemTransforms() {
            return new ItemTransforms(BackpackBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND)), BackpackBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND)), BackpackBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND)), BackpackBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND)), BackpackBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.HEAD)), BackpackBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.GUI)), BackpackBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.GROUND)), BackpackBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIXED)));
        }

        private static ItemTransform fromTransformation(Transformation transformation) {
            return new ItemTransform(transformation.m_121105_().m_175217_(), transformation.m_175940_(), transformation.m_175941_());
        }

        public BackpackBakedModel(Map<ModelPart, BakedModel> models, ModelState modelTransform) {
            this.models = models;
            this.modelTransform = modelTransform;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>(this.models.get((Object)ModelPart.BASE).getQuads(state, side, rand, extraData));
            if (state == null) {
                this.addLeftSide(state, side, rand, extraData, ret, this.tankLeft);
                this.addRightSide(state, side, rand, extraData, ret, this.tankRight);
                this.addFront(state, side, rand, extraData, ret, this.battery);
            } else {
                this.addLeftSide(state, side, rand, extraData, ret, (Boolean)state.m_61143_((Property)BackpackBlock.LEFT_TANK));
                this.addRightSide(state, side, rand, extraData, ret, (Boolean)state.m_61143_((Property)BackpackBlock.RIGHT_TANK));
                this.addFront(state, side, rand, extraData, ret, (Boolean)state.m_61143_((Property)BackpackBlock.BATTERY));
            }
            return ret;
        }

        private void addFront(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData, List<BakedQuad> ret, boolean battery) {
            if (battery) {
                if (this.batteryRenderInfo != null) {
                    this.addCharge(ret, this.batteryRenderInfo.getChargeRatio());
                }
                ret.addAll(this.models.get((Object)ModelPart.BATTERY).getQuads(state, side, rand, extraData));
            } else {
                ret.addAll(this.models.get((Object)ModelPart.FRONT_POUCH).getQuads(state, side, rand, extraData));
            }
        }

        private void addCharge(List<BakedQuad> ret, float chargeRatio) {
            if (Mth.m_14033_((float)chargeRatio, (float)0.0f)) {
                return;
            }
            int pixels = (int)(chargeRatio * 4.0f);
            float minX = (float)(10 - pixels) / 16.0f;
            float minY = 0.125f;
            float minZ = 0.121875f;
            float maxX = minX + (float)pixels / 16.0f;
            float maxY = minY + 0.0625f;
            float[] cols = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(BACKPACK_MODULES_TEXTURE);
            ret.add(this.createQuad(List.of(this.getVector(maxX, maxY, minZ), this.getVector(maxX, minY, minZ), this.getVector(minX, minY, minZ), this.getVector(minX, maxY, minZ)), cols, sprite, Direction.NORTH, 14.0f, 14.0f + (float)pixels / 2.0f, 6.0f, 6.5f));
        }

        private void addRightSide(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData, List<BakedQuad> ret, boolean tankRight) {
            if (tankRight) {
                if (this.rightTankRenderInfo != null) {
                    this.rightTankRenderInfo.getFluid().ifPresent(fluid -> this.addFluid(ret, (FluidStack)fluid, this.rightTankRenderInfo.getFillRatio(), 0.0375));
                }
                ret.addAll(this.models.get((Object)ModelPart.RIGHT_TANK).getQuads(state, side, rand, extraData));
            } else {
                ret.addAll(this.models.get((Object)ModelPart.RIGHT_POUCH).getQuads(state, side, rand, extraData));
            }
        }

        private void addLeftSide(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData, List<BakedQuad> ret, boolean tankLeft) {
            if (tankLeft) {
                if (this.leftTankRenderInfo != null) {
                    this.leftTankRenderInfo.getFluid().ifPresent(fluid -> this.addFluid(ret, (FluidStack)fluid, this.leftTankRenderInfo.getFillRatio(), 0.803125));
                }
                ret.addAll(this.models.get((Object)ModelPart.LEFT_TANK).getQuads(state, side, rand, extraData));
            } else {
                ret.addAll(this.models.get((Object)ModelPart.LEFT_POUCH).getQuads(state, side, rand, extraData));
            }
        }

        private void addFluid(List<BakedQuad> ret, FluidStack fluidStack, float ratio, double xMin) {
            if (Mth.m_14033_((float)ratio, (float)0.0f)) {
                return;
            }
            double yMin = 0.09375;
            double yMax = yMin + (double)(ratio * 6.0f) / 16.0;
            AABB bounds = new AABB(xMin, yMin, 0.421875, xMin + 0.15625, yMax, 0.578125);
            ResourceLocation texture = fluidStack.getFluid().getAttributes().getStillTexture(fluidStack);
            int color = fluidStack.getFluid().getAttributes().getColor(fluidStack);
            float[] cols = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
            float bx1 = 0.0f;
            float bx2 = 5.0f;
            float by1 = 0.0f;
            float by2 = ratio * 10.0f;
            float bz1 = 0.0f;
            float bz2 = 5.0f;
            ret.add(this.createQuad(List.of(this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_), this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_)), cols, still, Direction.UP, bx1, bx2, bz1, bz2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_), this.getVector(bounds.f_82291_, bounds.f_82289_, bounds.f_82290_), this.getVector(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_), this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_)), cols, still, Direction.NORTH, bx1, bx2, by1, by2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_), this.getVector(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82289_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_)), cols, still, Direction.SOUTH, bx1, bx2, by1, by2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_), this.getVector(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_), this.getVector(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_), this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_)), cols, still, Direction.WEST, bz1, bz2, by1, by2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82289_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82289_, bounds.f_82290_), this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_)), cols, still, Direction.EAST, bz1, bz2, by1, by2));
        }

        private Vector3f getVector(double x, double y, double z) {
            Vector3f ret = new Vector3f((float)x, (float)y, (float)z);
            this.rotate(ret, this.modelTransform.m_6189_().m_121104_());
            return ret;
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return true;
        }

        public TextureAtlasSprite m_6160_() {
            return this.models.get((Object)ModelPart.BASE).m_6160_();
        }

        public ItemOverrides m_7343_() {
            return this.overrideList;
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack matrixStack) {
            if (cameraTransformType == ItemTransforms.TransformType.NONE) {
                return this;
            }
            Transformation tr = TRANSFORMS.get(cameraTransformType);
            if (!tr.isIdentity()) {
                tr.push(matrixStack);
            }
            return this;
        }

        public ItemTransforms m_7442_() {
            return ITEM_TRANSFORMS;
        }

        private BakedQuad createQuad(List<Vector3f> vecs, float[] colors, TextureAtlasSprite sprite, Direction face, float u1, float u2, float v1, float v2) {
            BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
            Vec3i dirVec = face.m_122436_();
            Vector3f normal = new Vector3f((float)dirVec.m_123341_(), (float)dirVec.m_123342_(), (float)dirVec.m_123343_());
            this.putVertex(builder, normal, vecs.get(0).m_122239_(), vecs.get(0).m_122260_(), vecs.get(0).m_122269_(), u1, v1, sprite, colors);
            this.putVertex(builder, normal, vecs.get(1).m_122239_(), vecs.get(1).m_122260_(), vecs.get(1).m_122269_(), u1, v2, sprite, colors);
            this.putVertex(builder, normal, vecs.get(2).m_122239_(), vecs.get(2).m_122260_(), vecs.get(2).m_122269_(), u2, v2, sprite, colors);
            this.putVertex(builder, normal, vecs.get(3).m_122239_(), vecs.get(3).m_122260_(), vecs.get(3).m_122269_(), u2, v1, sprite, colors);
            builder.setQuadOrientation(face);
            return builder.build();
        }

        private void putVertex(BakedQuadBuilder builder, Vector3f normal, float x, float y, float z, float u, float v, TextureAtlasSprite sprite, float[] col) {
            ImmutableList elements = builder.getVertexFormat().m_86023_();
            block6: for (int e = 0; e < elements.size(); ++e) {
                switch (((VertexFormatElement)elements.get(e)).m_86048_()) {
                    case POSITION: {
                        builder.put(e, new float[]{x, y, z});
                        continue block6;
                    }
                    case COLOR: {
                        builder.put(e, new float[]{col[1], col[2], col[3], col[0]});
                        continue block6;
                    }
                    case UV: {
                        if (((VertexFormatElement)elements.get(e)).m_86049_() == 0) {
                            float iu = sprite.m_118367_((double)u);
                            float iv = sprite.m_118393_((double)v);
                            builder.put(e, new float[]{iu, iv});
                            continue block6;
                        }
                        builder.put(e, new float[0]);
                        continue block6;
                    }
                    case NORMAL: {
                        builder.put(e, new float[]{normal.m_122239_(), normal.m_122260_(), normal.m_122269_()});
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        private void rotate(Vector3f posIn, Matrix4f transformIn) {
            Vector3f originIn = new Vector3f(0.5f, 0.5f, 0.5f);
            Vector4f vector4f = new Vector4f(posIn.m_122239_() - originIn.m_122239_(), posIn.m_122260_() - originIn.m_122260_(), posIn.m_122269_() - originIn.m_122269_(), 1.0f);
            vector4f.m_123607_(transformIn);
            posIn.m_122245_(vector4f.m_123601_() + originIn.m_122239_(), vector4f.m_123615_() + originIn.m_122260_(), vector4f.m_123616_() + originIn.m_122269_());
        }

        static {
            BACKPACK_MODULES_TEXTURE = new ResourceLocation("sophisticatedbackpacks:block/backpack_modules");
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.0f, -0.125f, -0.28125f), new Quaternion(85.0f, -90.0f, 0.0f, true), new Vector3f(0.75f, 0.75f, 0.75f), null));
            builder.put((Object)ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new Transformation(new Vector3f(0.0f, -0.125f, -0.28125f), new Quaternion(85.0f, -90.0f, 0.0f, true), new Vector3f(0.75f, 0.75f, 0.75f), null));
            builder.put((Object)ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.5f, 0.5f, 0.5f), null));
            builder.put((Object)ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.5f, 0.5f, 0.5f), null));
            builder.put((Object)ItemTransforms.TransformType.HEAD, (Object)new Transformation(new Vector3f(0.0f, 0.890625f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(1.0f, 1.0f, 1.0f), null));
            builder.put((Object)ItemTransforms.TransformType.GUI, (Object)new Transformation(new Vector3f(0.0f, 0.078125f, 0.0f), new Quaternion(30.0f, 225.0f, 0.0f, true), new Vector3f(0.9f, 0.9f, 0.9f), null));
            builder.put((Object)ItemTransforms.TransformType.GROUND, (Object)new Transformation(new Vector3f(0.0f, 0.1875f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.5f, 0.5f, 0.5f), null));
            builder.put((Object)ItemTransforms.TransformType.FIXED, (Object)new Transformation(new Vector3f(0.0f, 0.0f, -0.140625f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.75f, 0.75f, 0.75f), null));
            TRANSFORMS = builder.build();
            ITEM_TRANSFORMS = BackpackBakedModel.createItemTransforms();
        }
    }

    private static enum ModelPart {
        BASE,
        BATTERY,
        FRONT_POUCH,
        LEFT_POUCH,
        LEFT_TANK,
        RIGHT_POUCH,
        RIGHT_TANK;

    }

    public static final class Loader
    implements IModelLoader<BackpackDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public void m_6213_(ResourceManager resourceManager) {
        }

        public BackpackDynamicModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ResourceLocation clipsTexture;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableMap.Builder texturesBuilder = ImmutableMap.builder();
            if (modelContents.has("clipsTexture") && (clipsTexture = ResourceLocation.m_135820_((String)modelContents.get("clipsTexture").getAsString())) != null) {
                texturesBuilder.put((Object)"clips", (Object)Either.left((Object)new Material(InventoryMenu.f_39692_, clipsTexture)));
            }
            ImmutableMap textures = texturesBuilder.build();
            for (ModelPart part : ModelPart.values()) {
                this.addPartModel((ImmutableMap.Builder<ModelPart, UnbakedModel>)builder, part, (ImmutableMap<String, Either<Material, String>>)textures);
            }
            return new BackpackDynamicModel((Map<ModelPart, UnbakedModel>)builder.build());
        }

        private void addPartModel(ImmutableMap.Builder<ModelPart, UnbakedModel> builder, ModelPart modelPart, ImmutableMap<String, Either<Material, String>> textures) {
            builder.put((Object)modelPart, (Object)new BlockModel(SophisticatedBackpacks.getRL("block/backpack_" + modelPart.name().toLowerCase(Locale.ENGLISH)), Collections.emptyList(), textures, true, null, ItemTransforms.f_111786_, Collections.emptyList()));
        }
    }

    private static class BackpackItemOverrideList
    extends ItemOverrides {
        private final BackpackBakedModel backpackModel;

        public BackpackItemOverrideList(BackpackBakedModel backpackModel) {
            this.backpackModel = backpackModel;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity, int seed) {
            this.backpackModel.tankRight = false;
            this.backpackModel.tankLeft = false;
            this.backpackModel.battery = false;
            stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> {
                RenderInfo renderInfo = backpackWrapper.getRenderInfo();
                Map tankRenderInfos = renderInfo.getTankRenderInfos();
                tankRenderInfos.forEach((pos, info) -> {
                    if (pos == TankPosition.LEFT) {
                        this.backpackModel.tankLeft = true;
                        this.backpackModel.leftTankRenderInfo = info;
                    } else {
                        this.backpackModel.tankRight = true;
                        this.backpackModel.rightTankRenderInfo = info;
                    }
                });
                renderInfo.getBatteryRenderInfo().ifPresent(batteryRenderInfo -> {
                    this.backpackModel.battery = true;
                    this.backpackModel.batteryRenderInfo = batteryRenderInfo;
                });
            });
            return this.backpackModel;
        }
    }
}

