/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.utils;

import com.tarinoita.solapplepie.SOLApplePie;
import com.tarinoita.solapplepie.tracking.FoodInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class ComplexityParser {
    public static Map<FoodInstance, Double> parse(List<String> unparsed) {
        HashMap<FoodInstance, Double> complexityMap = new HashMap<FoodInstance, Double>();
        for (String complexityString : unparsed) {
            Item item;
            String[] s = complexityString.split(",", 0);
            if (s.length != 2) {
                SOLApplePie.LOGGER.warn("Invalid complexity specification: " + complexityString);
                continue;
            }
            String foodString = s[0];
            double complexity = 1.0;
            try {
                complexity = Double.parseDouble(s[1]);
            }
            catch (NumberFormatException e) {
                SOLApplePie.LOGGER.warn("Second argument in complexity specification needs to be a number: " + complexityString);
                continue;
            }
            try {
                item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(foodString));
            }
            catch (ResourceLocationException e) {
                SOLApplePie.LOGGER.warn("Invalid item name: " + foodString);
                continue;
            }
            if (item == null) {
                SOLApplePie.LOGGER.warn("Invalid item name: " + foodString);
                continue;
            }
            if (!item.m_41472_()) {
                SOLApplePie.LOGGER.warn("Item is not food: " + foodString);
                continue;
            }
            FoodInstance food = new FoodInstance(item);
            if (food.encode() == null) {
                SOLApplePie.LOGGER.warn("Item does not exist: " + foodString);
                continue;
            }
            complexityMap.put(food, complexity);
        }
        return complexityMap;
    }
}

