/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.tracking.benefits;

import com.tarinoita.solapplepie.tracking.CapabilityHandler;
import com.tarinoita.solapplepie.tracking.benefits.EffectBenefit;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class EffectBenefitsCapability
implements ICapabilitySerializable<CompoundTag>,
Iterable<EffectBenefit> {
    private final Set<EffectBenefit> effectBenefits = new HashSet<EffectBenefit>();
    private final LazyOptional<EffectBenefitsCapability> capabilityOptional = LazyOptional.of(() -> this);
    private static final String NBT_KEY_EFFECT_BENEFITS = "effect_benefits";

    public static EffectBenefitsCapability get(Player player) {
        return (EffectBenefitsCapability)player.getCapability(CapabilityHandler.effectBenefitsCapability).orElseThrow(EffectsBenefitsNotFoundException::new);
    }

    public void addEffectBenefit(EffectBenefit b) {
        this.effectBenefits.add(b);
    }

    public void addEffectBenefitUnique(EffectBenefit b) {
        this.effectBenefits.removeIf(other -> other.getName().equals(b.getName()));
        this.addEffectBenefit(b);
    }

    public void removeEffectBenefit(EffectBenefit b) {
        this.effectBenefits.remove(b);
    }

    public void clear() {
        this.effectBenefits.clear();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        return capability == CapabilityHandler.effectBenefitsCapability ? this.capabilityOptional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        this.effectBenefits.stream().map(EffectBenefit::serializeNBT).forEach(arg_0 -> list.add(arg_0));
        tag.m_128365_(NBT_KEY_EFFECT_BENEFITS, (Tag)list);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag list = tag.m_128437_(NBT_KEY_EFFECT_BENEFITS, 10);
        this.effectBenefits.clear();
        list.stream().map(nbt -> (CompoundTag)nbt).map(EffectBenefit::fromNBT).forEach(this.effectBenefits::add);
    }

    @Override
    @Nonnull
    public Iterator<EffectBenefit> iterator() {
        return this.effectBenefits.iterator();
    }

    public static class EffectsBenefitsNotFoundException
    extends RuntimeException {
        public EffectsBenefitsNotFoundException() {
            super("Player must have effect benefits capability attached, but none was found.");
        }
    }
}

