/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.tracking.benefits;

import com.tarinoita.solapplepie.ConfigHandler;
import com.tarinoita.solapplepie.SOLApplePieConfig;
import com.tarinoita.solapplepie.tracking.CapabilityHandler;
import com.tarinoita.solapplepie.tracking.FoodList;
import com.tarinoita.solapplepie.tracking.benefits.Benefit;
import com.tarinoita.solapplepie.tracking.benefits.BenefitInfo;
import com.tarinoita.solapplepie.tracking.benefits.EffectBenefitsCapability;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="solapplepie")
public class BenefitsHandler {
    @SubscribeEvent
    public static void tickBenefits(LivingEvent.LivingUpdateEvent event) {
        if (!BenefitsHandler.checkEvent((LivingEvent)event)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!player.m_6084_()) {
            return;
        }
        EffectBenefitsCapability effectBenefits = EffectBenefitsCapability.get(player);
        effectBenefits.forEach(b -> b.onTick(player));
    }

    public static void updateBenefits(Player player, double diversity) {
        if (player.m_20193_().f_46443_) {
            return;
        }
        FoodList foodList = FoodList.get(player);
        if (foodList.getFoodsEaten() < SOLApplePieConfig.minFoodsToActivate()) {
            return;
        }
        List<List<Benefit>> benefitsList = ConfigHandler.getBenefitsList();
        List<Double> thresholds = ConfigHandler.thresholds;
        EffectBenefitsCapability effectBenefits = EffectBenefitsCapability.get(player);
        effectBenefits.clear();
        for (int i = 0; i < thresholds.size(); ++i) {
            double thresh = thresholds.get(i);
            if (i >= benefitsList.size()) {
                return;
            }
            if (diversity >= thresh) {
                benefitsList.get(i).forEach(b -> b.applyTo(player));
                continue;
            }
            benefitsList.get(i).forEach(b -> b.removeFrom(player));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        BenefitsHandler.updatePlayer((LivingEvent)event);
        CapabilityHandler.syncFoodList(event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getPlayer();
        player.reviveCaps();
        BenefitsHandler.removeAllBenefits(player);
        player.invalidateCaps();
    }

    public static void removeAllBenefits(Player player) {
        List<List<Benefit>> benefitsList = ConfigHandler.getBenefitsList();
        benefitsList.forEach(bt -> bt.forEach(b -> b.removeFrom(player)));
    }

    public static void updatePlayer(LivingEvent event) {
        if (!BenefitsHandler.checkEvent(event)) {
            return;
        }
        Player player = (Player)event.getEntity();
        BenefitsHandler.updatePlayer(player);
    }

    public static void updatePlayer(Player player) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        FoodList foodList = FoodList.get(player);
        double diversity = foodList.foodDiversity();
        BenefitsHandler.updateBenefits(player, diversity);
    }

    public static boolean checkEvent(LivingEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return false;
        }
        Player player = (Player)event.getEntity();
        if (player.f_19853_.f_46443_) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        boolean isInSurvival = serverPlayer.f_8941_.m_9294_();
        return !SOLApplePieConfig.limitProgressionToSurvival() || isInSurvival;
    }

    public static Pair<List<BenefitInfo>, List<BenefitInfo>> getBenefitInfo(double active_threshold, int foodEaten) {
        ArrayList activeBenefitInfo = new ArrayList();
        ArrayList inactiveBenefitInfo = new ArrayList();
        if (foodEaten < SOLApplePieConfig.minFoodsToActivate()) {
            active_threshold = -1.0;
        }
        List<List<Benefit>> benefitsList = ConfigHandler.getBenefitsList();
        List<Double> thresholds = ConfigHandler.thresholds;
        for (int i = 0; i < thresholds.size(); ++i) {
            double thresh = thresholds.get(i);
            if (i >= benefitsList.size()) break;
            if (active_threshold >= thresh) {
                benefitsList.get(i).forEach(b -> activeBenefitInfo.add(new BenefitInfo(b.getType(), b.getName(), b.getValue(), thresh)));
                continue;
            }
            benefitsList.get(i).forEach(b -> inactiveBenefitInfo.add(new BenefitInfo(b.getType(), b.getName(), b.getValue(), thresh)));
        }
        return new ImmutablePair(activeBenefitInfo, inactiveBenefitInfo);
    }
}

