/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.tracking.benefits;

import com.tarinoita.solapplepie.SOLApplePie;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public abstract class Benefit {
    protected final String benefitType;
    protected final String name;
    protected final double value;
    protected boolean invalid = false;
    protected final double threshold;

    public Benefit(String benefitType, String name, double value, double threshold) {
        this.benefitType = benefitType;
        this.name = name;
        this.value = value;
        this.threshold = threshold;
    }

    public abstract void applyTo(Player var1);

    public abstract void removeFrom(Player var1);

    public boolean isInvalid() {
        return this.invalid;
    }

    protected void markInvalid() {
        SOLApplePie.LOGGER.warn("Invalid attribute specified in config: " + this.name);
        this.invalid = true;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.benefitType;
    }

    public double getValue() {
        return this.value;
    }

    public abstract CompoundTag serializeNBT();

    public String toString() {
        return "[" + this.benefitType + ", " + this.name + ", " + this.value + "]";
    }

    public int hashCode() {
        int r = 31 * this.name.hashCode() + Double.valueOf(this.value).hashCode();
        return 31 * r + Double.valueOf(this.threshold).hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Benefit)) {
            return false;
        }
        Benefit b = (Benefit)other;
        return this.benefitType.equals(b.benefitType) && this.name.equals(b.name) && this.value == b.value && b.threshold == this.threshold;
    }
}

