/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.tracking.benefits;

import com.tarinoita.solapplepie.ConfigHandler;
import com.tarinoita.solapplepie.SOLApplePie;
import com.tarinoita.solapplepie.tracking.benefits.Benefit;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public final class AttributeBenefit
extends Benefit {
    private final AttributeModifier modifier;
    private final UUID id;
    private Attribute attribute;
    private final boolean isMaxHealth;

    public AttributeBenefit(String name, double value, double threshold) {
        super("attribute", name, value, threshold);
        this.id = UUID.randomUUID();
        this.modifier = new AttributeModifier(this.id, name + "_modifier_" + value, value, AttributeModifier.Operation.ADDITION);
        this.isMaxHealth = name.equals("generic.max_health");
    }

    public AttributeBenefit(String name, double value, double threshold, String uuid) {
        super("attribute", name, value, threshold);
        this.id = UUID.fromString(uuid);
        this.modifier = new AttributeModifier(this.id, name + "_modifier_" + value, value, AttributeModifier.Operation.ADDITION);
        this.isMaxHealth = name.equals("generic.max_health");
    }

    @Override
    public void applyTo(Player player) {
        AttributeInstance attr;
        if (!this.checkUsage() || player.f_19853_.f_46443_) {
            return;
        }
        float oldMax = player.m_21233_();
        try {
            attr = Objects.requireNonNull(player.m_21051_(this.attribute));
        }
        catch (NullPointerException e) {
            SOLApplePie.LOGGER.warn("ERROR: player does not have attribute: " + this.attribute.getRegistryName());
            return;
        }
        attr.m_22130_(this.modifier);
        attr.m_22125_(this.modifier);
        if (this.isMaxHealth && !ConfigHandler.isFirstAid) {
            float newHealth = player.m_21223_() * player.m_21233_() / oldMax;
            player.m_21153_(newHealth);
        }
    }

    @Override
    public void removeFrom(Player player) {
        AttributeInstance attr;
        if (!this.checkUsage() || player.f_19853_.f_46443_) {
            return;
        }
        try {
            attr = Objects.requireNonNull(player.m_21051_(this.attribute));
        }
        catch (NullPointerException e) {
            SOLApplePie.LOGGER.warn("ERROR: player does not have attribute: " + this.attribute.getRegistryName());
            return;
        }
        attr.m_22130_(this.modifier);
    }

    private boolean checkUsage() {
        if (this.invalid) {
            return false;
        }
        if (this.attribute == null) {
            this.createAttribute();
            return !this.invalid;
        }
        return true;
    }

    private void createAttribute() {
        try {
            this.attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(this.name));
        }
        catch (ResourceLocationException e) {
            this.markInvalid();
            return;
        }
        if (this.attribute == null || this.value == 0.0) {
            this.markInvalid();
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        StringTag type = StringTag.m_129297_((String)this.benefitType);
        StringTag n = StringTag.m_129297_((String)this.name);
        DoubleTag v = DoubleTag.m_128500_((double)this.value);
        StringTag uuid = StringTag.m_129297_((String)this.id.toString());
        DoubleTag thresh = DoubleTag.m_128500_((double)this.threshold);
        tag.m_128365_("type", (Tag)type);
        tag.m_128365_("name", (Tag)n);
        tag.m_128365_("value", (Tag)v);
        tag.m_128365_("id", (Tag)uuid);
        tag.m_128365_("threshold", (Tag)thresh);
        return tag;
    }

    public static AttributeBenefit fromNBT(CompoundTag tag) {
        String type = tag.m_128461_("type");
        if (!type.equals("attribute")) {
            throw new RuntimeException("Mismatching benefit type");
        }
        String n = tag.m_128461_("name");
        double v = tag.m_128459_("value");
        String uuid = tag.m_128461_("id");
        double thresh = tag.m_128459_("threshold");
        return new AttributeBenefit(n, v, thresh, uuid);
    }
}

