/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.tracking;

import com.tarinoita.solapplepie.SOLApplePie;
import com.tarinoita.solapplepie.item.foodcontainer.FoodContainerItem;
import com.tarinoita.solapplepie.tracking.CapabilityHandler;
import com.tarinoita.solapplepie.tracking.FoodList;
import com.tarinoita.solapplepie.tracking.benefits.BenefitsHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="solapplepie")
public final class FoodTracker {
    @SubscribeEvent
    public static void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        if (!BenefitsHandler.checkEvent((LivingEvent)event)) {
            return;
        }
        Player player = (Player)event.getEntity();
        Item usedItem = event.getItem().m_41720_();
        if (!usedItem.m_41472_() && usedItem != Items.f_42502_) {
            return;
        }
        if (usedItem instanceof FoodContainerItem) {
            return;
        }
        FoodTracker.updateFoodList(usedItem, player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCakeBlockEaten(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        BlockState state = event.getWorld().m_8055_(event.getPos());
        Block clickedBlock = state.m_60734_();
        Player player = event.getPlayer();
        if (player.m_36391_(false) && event.getHand() == InteractionHand.MAIN_HAND) {
            Item eatenItem = clickedBlock.m_5456_();
            if (clickedBlock == Blocks.f_50145_) {
                if (SOLApplePie.HasFarmersDelight()) {
                    eatenItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("farmersdelight:cake_slice"));
                }
                assert (eatenItem != null);
                FoodTracker.updateFoodList(eatenItem, player);
            }
            if (eatenItem.getRegistryName().m_135827_().equals("farmersdelight") && clickedBlock.getClass().getName().contains("PieBlock") && (eatenItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(eatenItem.getRegistryName().toString() + "_slice"))) != null) {
                FoodTracker.updateFoodList(eatenItem, player);
            }
        }
    }

    public static void updateFoodList(Item food, Player player) {
        FoodList foodList = FoodList.get(player);
        foodList.addFood(food);
        double diversity = foodList.foodDiversity();
        BenefitsHandler.updateBenefits(player, diversity);
        CapabilityHandler.syncFoodList(player);
    }

    private FoodTracker() {
    }
}

