/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.tracking;

import com.tarinoita.solapplepie.ConfigHandler;
import com.tarinoita.solapplepie.SOLApplePieConfig;
import com.tarinoita.solapplepie.api.FoodCapability;
import com.tarinoita.solapplepie.api.SOLApplePieAPI;
import com.tarinoita.solapplepie.tracking.FoodInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
public final class FoodList
implements FoodCapability {
    private static final String NBT_KEY_FOOD_LIST = "foodList";
    private static final String NBT_KEY_UNIQUE_FOOD = "food";
    private static final String NBT_KEY_LAST_EATEN = "lastEaten";
    private static final String NBT_KEY_FOODS_EATEN = "foodsEaten";
    private static final int MAX_FOODS_EATEN = 1000;
    private int foodsEaten = 0;
    private final Map<FoodInstance, Integer> uniqueFoods = new HashMap<FoodInstance, Integer>();
    private final LazyOptional<FoodList> capabilityOptional = LazyOptional.of(() -> this);

    public static FoodList get(Player player) {
        return (FoodList)player.getCapability(SOLApplePieAPI.foodCapability).orElseThrow(FoodListNotFoundException::new);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        return capability == SOLApplePieAPI.foodCapability ? this.capabilityOptional.cast() : LazyOptional.empty();
    }

    @Nullable
    private CompoundTag serializeUniqueFood(Map.Entry<FoodInstance, Integer> foodPair) {
        FoodInstance food = foodPair.getKey();
        Integer lastEaten = foodPair.getValue();
        String encodedFood = food.encode();
        if (encodedFood == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        StringTag s = StringTag.m_129297_((String)encodedFood);
        FloatTag i = FloatTag.m_128566_((float)lastEaten.intValue());
        tag.m_128365_(NBT_KEY_UNIQUE_FOOD, (Tag)s);
        tag.m_128365_(NBT_KEY_LAST_EATEN, (Tag)i);
        return tag;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        this.uniqueFoods.entrySet().stream().map(this::serializeUniqueFood).filter(Objects::nonNull).forEach(arg_0 -> list.add(arg_0));
        tag.m_128365_(NBT_KEY_FOOD_LIST, (Tag)list);
        tag.m_128365_(NBT_KEY_FOODS_EATEN, (Tag)IntTag.m_128679_((int)this.foodsEaten));
        return tag;
    }

    @Nullable
    private Pair<FoodInstance, Integer> deserializeUniqueFood(Pair<String, Float> encoded) {
        FoodInstance uniqueFood = FoodInstance.decode((String)encoded.getKey());
        Integer lastEaten = Math.round(((Float)encoded.getValue()).floatValue());
        if (uniqueFood == null) {
            return null;
        }
        return new ImmutablePair((Object)uniqueFood, (Object)lastEaten);
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag list = tag.m_128437_(NBT_KEY_FOOD_LIST, 10);
        this.uniqueFoods.clear();
        list.stream().map(nbt -> (CompoundTag)nbt).map(nbt -> new ImmutablePair((Object)nbt.m_128461_(NBT_KEY_UNIQUE_FOOD), (Object)Float.valueOf(nbt.m_128457_(NBT_KEY_LAST_EATEN)))).map(this::deserializeUniqueFood).filter(Objects::nonNull).forEach(pair -> this.uniqueFoods.put((FoodInstance)pair.getKey(), (Integer)pair.getValue()));
        this.foodsEaten = tag.m_128451_(NBT_KEY_FOODS_EATEN);
    }

    public void addFood(Item food, Map<FoodInstance, Integer> foodMap) {
        if (!SOLApplePieConfig.shouldCount(food) && !SOLApplePieConfig.shouldForbiddenCount()) {
            return;
        }
        if (this.foodsEaten < 1000) {
            ++this.foodsEaten;
        }
        ArrayList<FoodInstance> toRemove = new ArrayList<FoodInstance>();
        for (Map.Entry<FoodInstance, Integer> entry : foodMap.entrySet()) {
            Integer lastEaten;
            FoodInstance foodInstance = entry.getKey();
            Integer n = lastEaten = entry.getValue();
            lastEaten = lastEaten + 1;
            foodMap.put(foodInstance, lastEaten);
            if (lastEaten < SOLApplePieConfig.size()) continue;
            toRemove.add(foodInstance);
        }
        for (FoodInstance foodInstance : toRemove) {
            foodMap.remove(foodInstance);
        }
        if (SOLApplePieConfig.shouldCount(food)) {
            FoodInstance newlyEaten = new FoodInstance(food);
            foodMap.put(newlyEaten, 0);
        }
    }

    public void addFood(Item food) {
        this.addFood(food, this.uniqueFoods);
    }

    public double simulateFoodAdd(Item food) {
        if (!SOLApplePieConfig.shouldCount(food) && !SOLApplePieConfig.shouldForbiddenCount()) {
            return 0.0;
        }
        double change = 0.0;
        for (Map.Entry<FoodInstance, Integer> entry : this.uniqueFoods.entrySet()) {
            FoodInstance foodInstance = entry.getKey();
            Integer lastEaten = entry.getValue();
            double diversityContribution = FoodList.calculateDiversityContribution(foodInstance, lastEaten);
            Integer n = lastEaten;
            lastEaten = lastEaten + 1;
            if (foodInstance.getItem().equals(food)) {
                change -= diversityContribution;
                continue;
            }
            if (lastEaten >= SOLApplePieConfig.size()) {
                change -= diversityContribution;
                continue;
            }
            double newDiversityContribution = FoodList.calculateDiversityContribution(foodInstance, lastEaten);
            change += newDiversityContribution - diversityContribution;
        }
        if (SOLApplePieConfig.shouldCount(food)) {
            change += FoodList.calculateDiversityContribution(new FoodInstance(food), 0);
        }
        return change;
    }

    @Override
    public double foodDiversity() {
        return FoodList.foodDiversity(this.uniqueFoods.entrySet());
    }

    public static double foodDiversity(Set<Map.Entry<FoodInstance, Integer>> foodData) {
        double diversity = 0.0;
        for (Map.Entry<FoodInstance, Integer> entry : foodData) {
            FoodInstance food = entry.getKey();
            Integer lastEaten = entry.getValue();
            diversity += FoodList.calculateDiversityContribution(food, lastEaten);
        }
        return diversity;
    }

    public static double calculateDiversityContribution(FoodInstance food, int lastEaten) {
        return FoodList.calculateTimePenalty(lastEaten) * FoodList.getComplexity(food);
    }

    private static double calculateTimePenalty(int lastEaten) {
        int size = SOLApplePieConfig.size();
        int startDecay = SOLApplePieConfig.startDecay();
        int endDecay = SOLApplePieConfig.endDecay();
        double minContribution = SOLApplePieConfig.minContribution();
        if (startDecay > endDecay || startDecay < 0 || endDecay > size || startDecay > size || minContribution > 1.0 || minContribution < 0.0) {
            return 0.0;
        }
        if (lastEaten <= startDecay) {
            return 1.0;
        }
        if (lastEaten > endDecay) {
            return minContribution;
        }
        double slope = (1.0 - minContribution) / (double)(startDecay - endDecay);
        return slope * (double)(lastEaten - startDecay) + 1.0;
    }

    public static double getComplexity(FoodInstance food) {
        if (ConfigHandler.complexityMap != null && ConfigHandler.complexityMap.containsKey(food)) {
            return ConfigHandler.complexityMap.get(food);
        }
        FoodProperties foodProperties = food.item.m_41473_();
        if (foodProperties != null) {
            int nutrition = foodProperties.m_38744_();
            float saturation = (float)nutrition * foodProperties.m_38745_();
            float average = (saturation + (float)nutrition) / 2.0f;
            if (average < 5.0f) {
                return (double)average * SOLApplePieConfig.defaultContribution() / 5.0;
            }
            return SOLApplePieConfig.defaultContribution() * 4.0 * Math.log10(average - 4.0f) + 1.0;
        }
        return SOLApplePieConfig.defaultContribution();
    }

    public Set<Map.Entry<FoodInstance, Integer>> getData() {
        return this.uniqueFoods.entrySet();
    }

    public int getLastEaten(Item food) {
        if (!this.hasEaten(food)) {
            return -1;
        }
        return this.uniqueFoods.get(new FoodInstance(food));
    }

    @Override
    public boolean hasEaten(Item food) {
        if (!food.m_41472_()) {
            return false;
        }
        return this.uniqueFoods.containsKey(new FoodInstance(food));
    }

    public void clearFood() {
        this.uniqueFoods.clear();
    }

    public Set<FoodInstance> getEatenFoods() {
        return this.uniqueFoods.keySet();
    }

    public int getFoodsEaten() {
        return this.foodsEaten;
    }

    public void resetFoodsEaten() {
        this.foodsEaten = 0;
    }

    public static class FoodListNotFoundException
    extends RuntimeException {
        public FoodListNotFoundException() {
            super("Player must have food capability attached, but none was found.");
        }
    }
}

