/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.tracking;

import com.tarinoita.solapplepie.SOLApplePie;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class FoodInstance {
    public final Item item;

    public FoodInstance(Item item) {
        this.item = item;
    }

    @Nullable
    public static FoodInstance decode(String encoded) {
        ResourceLocation name = new ResourceLocation(encoded);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(name);
        if (item == null) {
            SOLApplePie.LOGGER.warn("attempting to load item into food list that is no longer registered: " + encoded + " (removing from list)");
            return null;
        }
        if (!item.m_41472_()) {
            SOLApplePie.LOGGER.warn("attempting to load item into food list that is no longer edible: " + encoded + " (ignoring in case it becomes edible again later)");
        }
        return new FoodInstance(item);
    }

    @Nullable
    public String encode() {
        return Optional.ofNullable(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item)).map(ResourceLocation::toString).orElse(null);
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FoodInstance)) {
            return false;
        }
        FoodInstance other = (FoodInstance)obj;
        return this.item.equals(other.item);
    }

    public Item getItem() {
        return this.item;
    }

    public String toString() {
        String enc = this.encode();
        if (enc == null) {
            return "null";
        }
        return enc;
    }
}

