/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.tracking;

import com.tarinoita.solapplepie.SOLApplePie;
import com.tarinoita.solapplepie.SOLApplePieConfig;
import com.tarinoita.solapplepie.api.FoodCapability;
import com.tarinoita.solapplepie.communication.FoodListMessage;
import com.tarinoita.solapplepie.tracking.FoodList;
import com.tarinoita.solapplepie.tracking.benefits.BenefitsHandler;
import com.tarinoita.solapplepie.tracking.benefits.EffectBenefitsCapability;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="solapplepie")
public final class CapabilityHandler {
    private static final ResourceLocation FOOD = SOLApplePie.resourceLocation("food");
    private static final ResourceLocation EFFECT_BENEFITS = SOLApplePie.resourceLocation("effect_benefits");
    public static Capability<EffectBenefitsCapability> effectBenefitsCapability = CapabilityManager.get((CapabilityToken)new CapabilityToken<EffectBenefitsCapability>(){});

    @SubscribeEvent
    public static void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Player)) {
            return;
        }
        event.addCapability(FOOD, (ICapabilityProvider)new FoodList());
        event.addCapability(EFFECT_BENEFITS, (ICapabilityProvider)new EffectBenefitsCapability());
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityHandler.syncFoodList(event.getPlayer());
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && SOLApplePieConfig.shouldResetOnDeath()) {
            return;
        }
        Player originalPlayer = event.getOriginal();
        originalPlayer.revive();
        FoodList original = FoodList.get(originalPlayer);
        FoodList newInstance = FoodList.get(event.getPlayer());
        newInstance.deserializeNBT(original.serializeNBT());
        BenefitsHandler.updatePlayer(event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        CapabilityHandler.syncFoodList(event.getPlayer());
    }

    public static void syncFoodList(Player player) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        ServerPlayer target = (ServerPlayer)player;
        SOLApplePie.channel.sendTo((Object)new FoodListMessage(FoodList.get(player)), target.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    @Mod.EventBusSubscriber(modid="solapplepie", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static final class RegisterCapabilitiesSubscriber {
        private RegisterCapabilitiesSubscriber() {
        }

        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.register(FoodCapability.class);
            event.register(EffectBenefitsCapability.class);
        }
    }
}

