/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.lib;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class Localization {
    public static String keyString(String domain, IForgeRegistryEntry<?> entry, String path) {
        ResourceLocation location = entry.getRegistryName();
        assert (location != null);
        return Localization.keyString(domain, location.m_135815_() + "." + path);
    }

    public static String keyString(String domain, String path) {
        return domain + ".solapplepie." + path;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localized(String domain, IForgeRegistryEntry<?> entry, String path, Object ... args) {
        return I18n.m_118938_((String)Localization.keyString(domain, entry, path), (Object[])args);
    }

    public static MutableComponent localizedComponent(String domain, IForgeRegistryEntry<?> entry, String path, Object ... args) {
        return new TranslatableComponent(Localization.keyString(domain, entry, path), args);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localized(String domain, String path, Object ... args) {
        return I18n.m_118938_((String)Localization.keyString(domain, path), (Object[])args);
    }

    public static MutableComponent localizedComponent(String domain, String path, Object ... args) {
        return new TranslatableComponent(Localization.keyString(domain, path), args);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localizedQuantity(String domain, String path, int number) {
        return number == 1 ? I18n.m_118938_((String)Localization.keyString(domain, path + ".singular"), (Object[])new Object[0]) : I18n.m_118938_((String)Localization.keyString(domain, path + ".plural"), (Object[])new Object[]{number});
    }

    public static MutableComponent localizedQuantityComponent(String domain, String path, int number) {
        return number == 1 ? new TranslatableComponent(Localization.keyString(domain, path + ".singular")) : new TranslatableComponent(Localization.keyString(domain, path + ".plural"), new Object[]{number});
    }

    public static String formatBigNumber(int number) {
        if (number < 1000) {
            return "" + number;
        }
        if (number < 10000) {
            return Math.round((float)number / 1000.0f) + "." + Math.round((float)(number % 1000) / 100.0f) + "k";
        }
        return Math.round((float)number / 1000.0f) + "k";
    }

    private Localization() {
    }
}

