/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.item.foodcontainer;

import com.tarinoita.solapplepie.client.ContainerScreenRegistry;
import com.tarinoita.solapplepie.item.foodcontainer.FoodContainerItem;
import com.tarinoita.solapplepie.item.foodcontainer.FoodSlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FoodContainer
extends AbstractContainerMenu {
    public static final int PLAYERSIZE = 36;
    public ItemStack containerItem;
    public int nslots;
    private Inventory playerInventory;

    public FoodContainer(int id, Inventory playerInventory, Player player) {
        super(ContainerScreenRegistry.food_container, id);
        if (player.m_21205_().m_41720_() instanceof FoodContainerItem) {
            this.containerItem = player.m_21205_();
        } else if (player.m_21206_().m_41720_() instanceof FoodContainerItem) {
            this.containerItem = player.m_21206_();
        } else {
            for (ItemStack stack : playerInventory.f_35974_) {
                if (!(stack.m_41720_() instanceof FoodContainerItem)) continue;
                this.containerItem = stack;
                break;
            }
        }
        this.playerInventory = playerInventory;
        this.containerItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            this.nslots = h.getSlots();
            int slotsPerRow = h.getSlots();
            if (h.getSlots() > 9) {
                slotsPerRow = h.getSlots() / 2;
            }
            int xStart = (178 - slotsPerRow * 18) / 2;
            int yStart = 35;
            if (h.getSlots() > 9) {
                yStart = 29;
            }
            for (int j = 0; j < h.getSlots(); ++j) {
                int row = j / slotsPerRow;
                int col = j % slotsPerRow;
                int xPos = xStart + col * 18;
                int yPos = yStart + row * 18;
                this.m_38897_((Slot)new FoodSlot((IItemHandler)h, j, xPos, yPos));
            }
        });
        this.layoutPlayerInventorySlots(8, 84);
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        ItemStack clickedStack;
        if (slotId >= 0 && slotId < this.f_38839_.size() && (clickedStack = ((Slot)this.f_38839_.get(slotId)).m_7993_()).m_41720_() instanceof FoodContainerItem) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack m_7648_(Player player, int slotId) {
        Slot clickedSlot = (Slot)this.f_38839_.get(slotId);
        if (clickedSlot == null || slotId < 0 || !clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack clickedStack = clickedSlot.m_7993_();
        if (!FoodSlot.canHold(clickedStack)) {
            return ItemStack.f_41583_;
        }
        ItemStack unchangedCopy = clickedStack.m_41777_();
        if (slotId < this.nslots ? !this.m_38903_(clickedStack, this.nslots, this.nslots + 36, false) : !this.m_38903_(clickedStack, 0, this.nslots, false)) {
            return ItemStack.f_41583_;
        }
        if (clickedStack.m_41619_()) {
            clickedSlot.m_5852_(ItemStack.f_41583_);
        } else {
            clickedSlot.m_6654_();
        }
        if (clickedStack.m_41613_() == unchangedCopy.m_41613_()) {
            return ItemStack.f_41583_;
        }
        clickedSlot.m_142406_(player, clickedStack);
        return clickedStack;
    }

    private int addSlotRange(Inventory handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_(new Slot((Container)handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(Inventory handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

