/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tarinoita.solapplepie.lib.Localization;
import com.tarinoita.solapplepie.tracking.CapabilityHandler;
import com.tarinoita.solapplepie.tracking.FoodList;
import com.tarinoita.solapplepie.tracking.benefits.BenefitsHandler;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="solapplepie")
public final class FoodListCommand {
    private static final String name = "solapplepie";

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)name).then(FoodListCommand.withPlayerArgumentOrSender(Commands.m_82127_((String)"sync"), FoodListCommand::syncFoodList))).then(FoodListCommand.withPlayerArgumentOrSender(Commands.m_82127_((String)"clear"), FoodListCommand::clearFoodList))).then(FoodListCommand.withPlayerArgumentOrSender(Commands.m_82127_((String)"diversity"), FoodListCommand::displayDiversity)));
    }

    static ArgumentBuilder<CommandSourceStack, ?> withPlayerArgumentOrSender(ArgumentBuilder<CommandSourceStack, ?> base, CommandWithPlayer command) {
        String target = "target";
        return base.executes(context -> command.run((CommandContext<CommandSourceStack>)context, (Player)((CommandSourceStack)context.getSource()).m_81375_())).then(Commands.m_82129_((String)target, (ArgumentType)EntityArgument.m_91466_()).executes(context -> command.run((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.m_91474_((CommandContext)context, (String)target))));
    }

    static int displayDiversity(CommandContext<CommandSourceStack> context, Player target) {
        boolean isOp = ((CommandSourceStack)context.getSource()).m_6761_(2);
        boolean isTargetingSelf = FoodListCommand.isTargetingSelf(context, target);
        if (!isOp && !isTargetingSelf) {
            throw new CommandRuntimeException((Component)FoodListCommand.localizedComponent("no_permissions", new Object[0]));
        }
        double diversity = FoodList.get(target).foodDiversity();
        MutableComponent feedback = FoodListCommand.localizedComponent("diversity_feedback", diversity);
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), feedback);
        return 1;
    }

    static int syncFoodList(CommandContext<CommandSourceStack> context, Player target) {
        CapabilityHandler.syncFoodList(target);
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), FoodListCommand.localizedComponent("sync.success", new Object[0]));
        System.out.println(target.m_21233_());
        return 1;
    }

    static int clearFoodList(CommandContext<CommandSourceStack> context, Player target) {
        boolean isOp = ((CommandSourceStack)context.getSource()).m_6761_(2);
        boolean isTargetingSelf = FoodListCommand.isTargetingSelf(context, target);
        if (!isOp && !isTargetingSelf) {
            throw new CommandRuntimeException((Component)FoodListCommand.localizedComponent("no_permissions", new Object[0]));
        }
        FoodList.get(target).clearFood();
        FoodList.get(target).resetFoodsEaten();
        BenefitsHandler.removeAllBenefits(target);
        BenefitsHandler.updatePlayer(target);
        CapabilityHandler.syncFoodList(target);
        MutableComponent feedback = FoodListCommand.localizedComponent("clear.success", new Object[0]);
        FoodListCommand.sendFeedback((CommandSourceStack)context.getSource(), feedback);
        if (!isTargetingSelf) {
            target.m_5661_((Component)FoodListCommand.applyFeedbackStyle(feedback), true);
        }
        return 1;
    }

    static void sendFeedback(CommandSourceStack source, MutableComponent message) {
        source.m_81354_((Component)FoodListCommand.applyFeedbackStyle(message), true);
    }

    private static MutableComponent applyFeedbackStyle(MutableComponent text) {
        return text.m_130938_(style -> style.m_131157_(ChatFormatting.DARK_AQUA));
    }

    static boolean isTargetingSelf(CommandContext<CommandSourceStack> context, Player target) {
        return target.m_7306_(Objects.requireNonNull(((CommandSourceStack)context.getSource()).m_81373_()));
    }

    static MutableComponent localizedComponent(String path, Object ... args) {
        return Localization.localizedComponent("command", FoodListCommand.localizationPath(path), args);
    }

    static MutableComponent localizedQuantityComponent(String path, int number) {
        return Localization.localizedQuantityComponent("command", FoodListCommand.localizationPath(path), number);
    }

    static String localizationPath(String path) {
        return "solapplepie." + path;
    }

    @FunctionalInterface
    private static interface CommandWithPlayer {
        public int run(CommandContext<CommandSourceStack> var1, Player var2) throws CommandSyntaxException;
    }
}

