/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.client.gui;

import com.tarinoita.solapplepie.client.gui.ItemListPage;
import com.tarinoita.solapplepie.client.gui.elements.UIFoodQueueItem;
import com.tarinoita.solapplepie.lib.Localization;
import com.tarinoita.solapplepie.tracking.FoodInstance;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;

public final class FoodListPage
extends ItemListPage {
    Map<FoodInstance, Integer> foodMap;

    private FoodListPage(Rectangle frame, String header, List<ItemStack> items, Map<FoodInstance, Integer> foodMap) {
        super(frame, header, items);
        this.setHeaderTooltip(Localization.localized("gui", "food_book.queue.food_queue_tooltip", new Object[0]));
        this.foodMap = foodMap;
        int minX = -40;
        int minY = -54;
        for (int i = 0; i < items.size(); ++i) {
            ItemStack itemStack = items.get(i);
            int x = minX + 20 * (i % 5);
            int y = minY + 20 * (i / 5 % 6);
            int lastEaten = foodMap.get(new FoodInstance(itemStack.m_41720_()));
            UIFoodQueueItem view = new UIFoodQueueItem(itemStack, lastEaten);
            view.setCenterX(this.getCenterX() + x);
            view.setCenterY(this.getCenterY() + y);
            this.children.add(view);
        }
    }

    static List<ItemListPage> pages(Rectangle frame, String header, List<ItemStack> items, Map<FoodInstance, Integer> foodMap) {
        ArrayList<ItemListPage> pages = new ArrayList<ItemListPage>();
        for (int startIndex = 0; startIndex < items.size(); startIndex += 30) {
            int endIndex = Math.min(startIndex + 30, items.size());
            pages.add(new FoodListPage(frame, header, items.subList(startIndex, endIndex), foodMap));
        }
        return pages;
    }
}

