/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tarinoita.solapplepie.SOLApplePie;
import com.tarinoita.solapplepie.SOLApplePieConfig;
import com.tarinoita.solapplepie.client.gui.BenefitsPage;
import com.tarinoita.solapplepie.client.gui.DiversityPage;
import com.tarinoita.solapplepie.client.gui.FoodListPage;
import com.tarinoita.solapplepie.client.gui.Page;
import com.tarinoita.solapplepie.client.gui.PageFlipButton;
import com.tarinoita.solapplepie.client.gui.elements.UIElement;
import com.tarinoita.solapplepie.client.gui.elements.UIImage;
import com.tarinoita.solapplepie.client.gui.elements.UILabel;
import com.tarinoita.solapplepie.lib.Localization;
import com.tarinoita.solapplepie.tracking.FoodInstance;
import com.tarinoita.solapplepie.tracking.FoodList;
import com.tarinoita.solapplepie.tracking.benefits.BenefitInfo;
import com.tarinoita.solapplepie.tracking.benefits.BenefitsHandler;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public final class FoodBookScreen
extends Screen
implements PageFlipButton.Pageable {
    private static final ResourceLocation texture = SOLApplePie.resourceLocation("textures/gui/food_book.png");
    private static final UIImage.Image bookImage = new UIImage.Image(texture, new Rectangle(0, 0, 186, 192));
    static final UIImage.Image carrotImage = new UIImage.Image(texture, new Rectangle(0, 240, 16, 16));
    static final Color fullBlack = Color.BLACK;
    static final Color lessBlack = new Color(0, 0, 0, 128);
    static final Color leastBlack = new Color(0, 0, 0, 64);
    static final Color activeGreen = new Color(29, 104, 29, 255);
    static final Color inactiveRed = new Color(104, 29, 29, 255);
    private final List<UIElement> elements = new ArrayList<UIElement>();
    private UIImage background;
    private UILabel pageNumberLabel;
    private PageFlipButton nextPageButton;
    private PageFlipButton prevPageButton;
    private Player player;
    private Set<Map.Entry<FoodInstance, Integer>> foodData;
    private final List<Page> pages = new ArrayList<Page>();
    private int currentPageNumber = 0;

    public static void open(Player player) {
        Minecraft.m_91087_().m_91152_((Screen)new FoodBookScreen(player));
    }

    public FoodBookScreen(Player player) {
        super((Component)new TextComponent(""));
        this.player = player;
    }

    public void m_7856_() {
        super.m_7856_();
        this.foodData = FoodList.get(this.player).getData();
        this.background = new UIImage(bookImage);
        this.background.setCenterX(this.f_96543_ / 2);
        this.background.setCenterY(this.f_96544_ / 2);
        this.elements.clear();
        this.pageNumberLabel = new UILabel("1");
        this.pageNumberLabel.setCenterX(this.background.getCenterX());
        this.pageNumberLabel.setMinY(this.background.getMinY() + 156);
        this.elements.add(this.pageNumberLabel);
        this.initPages();
        int pageFlipButtonSpacing = 50;
        this.prevPageButton = (PageFlipButton)this.m_142416_((GuiEventListener)new PageFlipButton(this.background.getCenterX() - pageFlipButtonSpacing / 2 - 23, this.background.getMinY() + 152, PageFlipButton.Direction.BACKWARD, this));
        this.nextPageButton = (PageFlipButton)this.m_142416_((GuiEventListener)new PageFlipButton(this.background.getCenterX() + pageFlipButtonSpacing / 2, this.background.getMinY() + 152, PageFlipButton.Direction.FORWARD, this));
        this.updateButtonVisibility();
    }

    private void initPages() {
        this.pages.clear();
        double foodDiversity = FoodList.foodDiversity(this.foodData);
        int foodEaten = FoodList.get(this.player).getFoodsEaten();
        this.pages.add(new DiversityPage(foodDiversity, foodEaten, this.background.frame));
        ArrayList<Map.Entry<FoodInstance, Integer>> dataList = new ArrayList<Map.Entry<FoodInstance, Integer>>(this.foodData);
        dataList.sort(Map.Entry.comparingByValue());
        List<Item> foods = dataList.stream().map(Map.Entry::getKey).map(FoodInstance::getItem).collect(Collectors.toList());
        this.addPages("food_queue_label", foods);
        Pair<List<BenefitInfo>, List<BenefitInfo>> benefits = BenefitsHandler.getBenefitInfo(foodDiversity, foodEaten);
        List activeBenefits = (List)benefits.getKey();
        List inactiveBenefits = (List)benefits.getValue();
        this.addPages("active_benefits_header", activeBenefits, activeGreen);
        if (SOLApplePieConfig.shouldShowInactiveBenefits()) {
            this.addPages("inactive_benefits_header", inactiveBenefits, inactiveRed);
        }
    }

    private void addPages(String headerLocalizationPath, List<BenefitInfo> benefitInfoList, Color activeColor) {
        String header = Localization.localized("gui", "food_book." + headerLocalizationPath, new Object[0]);
        this.pages.addAll(BenefitsPage.pages(this.background.frame, header, benefitInfoList, activeColor));
    }

    private void addPages(String headerLocalizationPath, List<Item> items) {
        String header = Localization.localized("gui", "food_book." + headerLocalizationPath, items.size());
        List<ItemStack> stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        HashMap<FoodInstance, Integer> foodMap = new HashMap<FoodInstance, Integer>();
        for (Map.Entry<FoodInstance, Integer> entry : this.foodData) {
            foodMap.put(entry.getKey(), entry.getValue());
        }
        this.pages.addAll(FoodListPage.pages(this.background.frame, header, stacks, foodMap));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrices);
        UIElement.render(matrices, this.background, mouseX, mouseY);
        super.m_6305_(matrices, mouseX, mouseY, partialTicks);
        if (!this.pages.isEmpty()) {
            UIElement.render(matrices, this.elements, mouseX, mouseY);
            UIElement.render(matrices, this.pages.get(this.currentPageNumber), mouseX, mouseY);
        }
    }

    @Override
    public void switchToPage(int pageNumber) {
        if (!this.isWithinRange(pageNumber)) {
            return;
        }
        this.currentPageNumber = pageNumber;
        this.updateButtonVisibility();
        this.pageNumberLabel.text = "" + (this.currentPageNumber + 1);
    }

    @Override
    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    @Override
    public boolean isWithinRange(int pageNumber) {
        return pageNumber >= 0 && pageNumber < this.pages.size();
    }

    private void updateButtonVisibility() {
        this.prevPageButton.updateState();
        this.nextPageButton.updateState();
    }
}

