/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solapplepie.client;

import com.tarinoita.solapplepie.SOLApplePieConfig;
import com.tarinoita.solapplepie.lib.Localization;
import com.tarinoita.solapplepie.tracking.FoodInstance;
import com.tarinoita.solapplepie.tracking.FoodList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="solapplepie")
public final class TooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (!SOLApplePieConfig.isFoodTooltipEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        Item food = event.getItemStack().m_41720_();
        if (!food.m_41472_()) {
            return;
        }
        FoodList foodList = FoodList.get(player);
        boolean hasBeenEaten = foodList.hasEaten(food);
        boolean isAllowed = SOLApplePieConfig.isAllowed(food);
        List tooltip = event.getToolTip();
        if (!isAllowed) {
            tooltip.add(TooltipHandler.localizedTooltip("disabled", ChatFormatting.DARK_GRAY));
        } else if (hasBeenEaten) {
            int lastEaten = foodList.getLastEaten(food);
            double contribution = FoodList.calculateDiversityContribution(new FoodInstance(food), lastEaten);
            TooltipHandler.addDiversityInfoTooltips(tooltip, contribution, lastEaten);
        } else {
            TooltipHandler.addDiversityInfoTooltips(tooltip, FoodList.getComplexity(new FoodInstance(food)), -1);
        }
    }

    private static Component localizedTooltip(String path, ChatFormatting color) {
        return Localization.localizedComponent("tooltip", path, new Object[0]).m_130938_(style -> style.m_131157_(color));
    }

    public static List<Component> addDiversityInfoTooltips(List<Component> tooltip, double contribution, int lastEaten) {
        String contribution_path = lastEaten == -1 ? "food_book.queue.tooltip.uneaten_contribution_label" : "food_book.queue.tooltip.contribution_label";
        tooltip.add((Component)new TextComponent(Localization.localized("gui", contribution_path, new Object[0]) + ": " + String.format("%.2f", contribution)).m_130940_(lastEaten == -1 ? ChatFormatting.GRAY : ChatFormatting.GOLD));
        if (lastEaten != -1) {
            String last_eaten_path = "food_book.queue.tooltip.last_eaten_label";
            if (lastEaten == 1) {
                last_eaten_path = "food_book.queue.tooltip.last_eaten_label_singular";
            }
            tooltip.add((Component)new TextComponent(Localization.localized("gui", last_eaten_path, lastEaten)).m_130940_(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    private TooltipHandler() {
    }
}

