/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.structure;

import com.cerbon.bosses_of_mass_destruction.config.BMDConfig;
import com.cerbon.bosses_of_mass_destruction.structure.StructureRegister;
import com.cerbon.bosses_of_mass_destruction.structure.gauntlet_arena.GauntletArenaStructureFeature;
import com.cerbon.bosses_of_mass_destruction.structure.lich_tower.LichTowerStructureFeature;
import com.cerbon.bosses_of_mass_destruction.structure.obsidilith_arena.ObsidilithArenaStructureFeature;
import com.cerbon.bosses_of_mass_destruction.structure.util.BMDStructurePiece;
import com.cerbon.bosses_of_mass_destruction.structure.util.CodeStructurePiece;
import com.cerbon.bosses_of_mass_destruction.structure.util.IPieceGenerator;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.VoidBlossomArenaStructureFeature;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.VoidBlossomCavernPieceGenerator;
import com.mojang.serialization.Codec;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class BMDStructures {
    public static final DeferredRegister<StructurePieceType> STRUCTURE_PIECES = DeferredRegister.create((ResourceKey)Registry.f_122842_, (String)"bosses_of_mass_destruction");
    public static final DeferredRegister<StructureFeature<?>> STRUCTURE_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122840_, (String)"bosses_of_mass_destruction");
    public static final BMDConfig config = (BMDConfig)AutoConfig.getConfigHolder(BMDConfig.class).getConfig();
    public static final StructureRegister OBSIDILITH_STRUCTURE_REGISTRY = new StructureRegister(new ResourceLocation("bosses_of_mass_destruction", "obsidilith_arena"));
    public static final StructureRegister VOID_BLOSSOM_STRUCTURE_REGISTRY = new StructureRegister(new ResourceLocation("bosses_of_mass_destruction", "void_blossom"));
    public static final StructureRegister GAUNTLET_STRUCTURE_REGISTRY = new StructureRegister(new ResourceLocation("bosses_of_mass_destruction", "gauntlet_arena"));
    public static final StructureRegister LICH_STRUCTURE_REGISTRY = new StructureRegister(new ResourceLocation("bosses_of_mass_destruction", "lich_tower"));
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> OBSIDILITH_ARENA_STRUCTURE_FEATURE = STRUCTURE_FEATURES.register("obsidilith_arena", () -> new ObsidilithArenaStructureFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, BMDStructures.config.obsidilithConfig));
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> VOID_BLOSSOM_STRUCTURE_FEATURE = STRUCTURE_FEATURES.register("void_blossom", () -> new VoidBlossomArenaStructureFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> GAUNTLET_STRUCTURE_FEATURE = STRUCTURE_FEATURES.register("gauntlet_arena", () -> new GauntletArenaStructureFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> LICH_TOWER_STRUCTURE_FEATURE = STRUCTURE_FEATURES.register("lich_tower", () -> new LichTowerStructureFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<StructurePieceType> OBSIDILITH_STRUCTURE_PIECE = STRUCTURE_PIECES.register("obsidilith_arena", () -> StructureFactories.OBSIDILITH_ARENA);
    public static final RegistryObject<StructurePieceType> VOID_BLOSSOM_CAVERN_PIECE = STRUCTURE_PIECES.register("void_blossom_piece", () -> StructureFactories.VOID_BLOSSOM);
    public static final RegistryObject<StructurePieceType> GAUNTLET_STRUCTURE_PIECE = STRUCTURE_PIECES.register("gauntlet_arena_piece", () -> StructureFactories.GAUNTLET_ARENA);
    public static final RegistryObject<StructurePieceType> LICH_STRUCTURE_PIECE = STRUCTURE_PIECES.register("lich_tower_piece", () -> StructureFactories.LICH_TOWER);
    public static final TagKey<ConfiguredStructureFeature<?, ?>> SOUL_STAR_STRUCTURE_KEY = TagKey.m_203882_((ResourceKey)Registry.f_122882_, (ResourceLocation)new ResourceLocation("bosses_of_mass_destruction", "soul_star_target"));
    public static final TagKey<ConfiguredStructureFeature<?, ?>> VOID_LILY_STRUCTURE_KEY = TagKey.m_203882_((ResourceKey)Registry.f_122882_, (ResourceLocation)new ResourceLocation("bosses_of_mass_destruction", "void_lily_target"));

    public static void register(IEventBus eventBus) {
        STRUCTURE_FEATURES.register(eventBus);
        STRUCTURE_PIECES.register(eventBus);
    }

    private static class StructureFactories {
        public static final StructurePieceType OBSIDILITH_ARENA = (context, tag) -> new BMDStructurePiece(context.f_192764_(), tag, (StructurePieceType)OBSIDILITH_STRUCTURE_PIECE.get());
        public static final StructurePieceType VOID_BLOSSOM = (context, tag) -> new CodeStructurePiece((StructurePieceType)VOID_BLOSSOM_CAVERN_PIECE.get(), tag, (IPieceGenerator)new VoidBlossomCavernPieceGenerator());
        public static final StructurePieceType GAUNTLET_ARENA = (context, tag) -> new BMDStructurePiece(context.f_192764_(), tag, (StructurePieceType)GAUNTLET_STRUCTURE_PIECE.get());
        public static final StructurePieceType LICH_TOWER = (context, tag) -> new BMDStructurePiece(context.f_192764_(), tag, (StructurePieceType)LICH_STRUCTURE_PIECE.get());

        private StructureFactories() {
        }
    }
}

