/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.particle;

import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.MathUtils;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.RandomUtils;
import com.cerbon.bosses_of_mass_destruction.particle.ParticleContext;
import com.cerbon.bosses_of_mass_destruction.particle.SimpleParticle;
import com.cerbon.bosses_of_mass_destruction.particle.SimpleParticleProvider;
import com.cerbon.bosses_of_mass_destruction.util.BMDColors;
import com.cerbon.bosses_of_mass_destruction.util.VanillaCopies;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BMDParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"bosses_of_mass_destruction");
    public static final RegistryObject<SimpleParticleType> DISAPPEARING_SWIRL = PARTICLE_TYPES.register("disappearing_swirl", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> SOUL_FLAME = PARTICLE_TYPES.register("soul_flame", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> MAGIC_CIRCLE = PARTICLE_TYPES.register("magic_circle", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_BURST = PARTICLE_TYPES.register("obsidilith_burst", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> ENCHANT = PARTICLE_TYPES.register("enchant", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_BURST_INDICATOR = PARTICLE_TYPES.register("obsidilith_burst_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_WAVE = PARTICLE_TYPES.register("obsidilith_wave", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_WAVE_INDICATOR = PARTICLE_TYPES.register("obsidilith_wave_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> DOWNSPARKLE = PARTICLE_TYPES.register("downsparkle", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_SPIKE_INDICATOR = PARTICLE_TYPES.register("obsidilith_spike_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_SPIKE = PARTICLE_TYPES.register("obsidilith_spike", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> PILLAR_RUNE = PARTICLE_TYPES.register("pillar_rune", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> PILLAR_SPAWN_INDICATOR = PARTICLE_TYPES.register("pillar_spawn_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> PILLAR_SPAWN_INDICATOR_2 = PARTICLE_TYPES.register("pillar_spawn_indicator_2", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_ANVIL_INDICATOR = PARTICLE_TYPES.register("obsidilith_anvil_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> SPARKLES = PARTICLE_TYPES.register("sparkles", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> GAUNTLET_REVIVE_SPARKLES = PARTICLE_TYPES.register("gauntlet_revive_sparkles", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> EYE_OPEN = PARTICLE_TYPES.register("eye_open", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> LINE = PARTICLE_TYPES.register("line", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> VOID_BLOSSOM_SPIKE_INDICATOR = PARTICLE_TYPES.register("void_blossom_spike_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> VOID_BLOSSOM_SPIKE_WAVE_INDICATOR = PARTICLE_TYPES.register("void_blossom_spike_wave_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> PETAL = PARTICLE_TYPES.register("petal", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> SPORE = PARTICLE_TYPES.register("spore", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> SPORE_INDICATOR = PARTICLE_TYPES.register("spore_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> FLUFF = PARTICLE_TYPES.register("fluff", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> POLLEN = PARTICLE_TYPES.register("pollen", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> EARTHDIVE_INDICATOR = PARTICLE_TYPES.register("earthdive_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> ROD = PARTICLE_TYPES.register("rod", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> GROUND_ROD = PARTICLE_TYPES.register("ground_rod", () -> new SimpleParticleType(true));
    public static final int FULL_BRIGHT = 0xF000F0;

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        particleEngine.m_107378_((ParticleType)DISAPPEARING_SWIRL.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(15, 20), VanillaCopies::buildBillBoardGeometry, true, true)));
        particleEngine.m_107378_((ParticleType)SOUL_FLAME.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(15, 20), VanillaCopies::buildBillBoardGeometry, true, true);
            particle.setColorOverride(f -> BMDColors.COMET_BLUE);
            particle.setBrightnessOverride(f -> 0xF000F0);
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)MAGIC_CIRCLE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, 40, VanillaCopies::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.m_6569_(4.0f);
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)OBSIDILITH_BURST.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(7, 15), VanillaCopies::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.m_6569_(4.0f);
            particle.setColorOverride(age -> MathUtils.lerpVec(age.floatValue(), BMDColors.ORANGE, BMDColors.RUNIC_BROWN));
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)ENCHANT.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(30, 50), VanillaCopies::buildBillBoardGeometry, false, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((float)((Math.sin((double)f.floatValue() * Math.PI) + 1.0) * (double)0.1f)));
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)OBSIDILITH_BURST_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, 30 + RandomUtils.range(-1, 2), VanillaCopies::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> BMDColors.ORANGE);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)OBSIDILITH_WAVE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(7, 15), VanillaCopies::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.m_6569_(4.0f);
            particle.setColorVariation(0.25);
            particle.setColorOverride(age -> MathUtils.lerpVec(age.floatValue(), BMDColors.RED, BMDColors.DARK_RED));
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)OBSIDILITH_WAVE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, 20 + RandomUtils.range(-1, 2), VanillaCopies::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> BMDColors.RED);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)DOWNSPARKLE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(15, 20), VanillaCopies::buildBillBoardGeometry, true, true)));
        particleEngine.m_107378_((ParticleType)OBSIDILITH_SPIKE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, 20 + RandomUtils.range(-1, 2), VanillaCopies::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> BMDColors.COMET_BLUE);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)OBSIDILITH_SPIKE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(15, 20), VanillaCopies::buildBillBoardGeometry, true, true);
            particle.setColorOverride(age -> MathUtils.lerpVec(age.floatValue(), BMDColors.WHITE, BMDColors.COMET_BLUE));
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setColorVariation(0.25);
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)PILLAR_RUNE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, 10, VanillaCopies::buildBillBoardGeometry, false, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((float)((Math.sin((double)f.floatValue() * Math.PI) + 1.0) * (double)0.1f)));
            particle.setColorOverride(age -> MathUtils.lerpVec(age.floatValue(), BMDColors.WHITE, BMDColors.ENDER_PURPLE));
            particle.setColorVariation(0.2);
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)PILLAR_SPAWN_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, 40, VanillaCopies::buildBillBoardGeometry, true, true);
            particle.setColorOverride(f -> BMDColors.ENDER_PURPLE);
            particle.m_6569_(2.0f);
            particle.setColorVariation(0.25);
            particle.setBrightnessOverride(f -> 0xF000F0);
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)PILLAR_SPAWN_INDICATOR_2.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, 40, VanillaCopies::buildBillBoardGeometry, false, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((float)((Math.sin((double)f.floatValue() * Math.PI) + 1.0) * (double)0.1f)));
            particle.setColorOverride(age -> MathUtils.lerpVec(age.floatValue(), BMDColors.WHITE, BMDColors.ENDER_PURPLE));
            particle.setColorVariation(0.2);
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)OBSIDILITH_ANVIL_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(25, 27), VanillaCopies::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> BMDColors.ENDER_PURPLE);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)SPARKLES.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(15, 20), VanillaCopies::buildBillBoardGeometry, true, true)));
        particleEngine.m_107378_((ParticleType)GAUNTLET_REVIVE_SPARKLES.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(15, 20), VanillaCopies::buildBillBoardGeometry, true, true);
            particle.setColorOverride(f -> BMDColors.LASER_RED);
            particle.setColorVariation(0.25);
            particle.setBrightnessOverride(f -> 0xF000F0);
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)EYE_OPEN.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(60, 70), VanillaCopies::buildBillBoardGeometry, true, true)));
        particleEngine.m_107378_((ParticleType)LINE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(20, 30), VanillaCopies::buildBillBoardGeometry, true, true)));
        particleEngine.m_107378_((ParticleType)ROD.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(8, 10), VanillaCopies::buildBillBoardGeometry, true, true)));
        particleEngine.m_107378_((ParticleType)GROUND_ROD.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(8, 10), VanillaCopies::buildFlatGeometry, true, true)));
        particleEngine.m_107378_((ParticleType)VOID_BLOSSOM_SPIKE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, 20 + RandomUtils.range(-1, 2), VanillaCopies::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> BMDColors.ENDER_PURPLE);
            particle.setColorVariation(0.2);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)VOID_BLOSSOM_SPIKE_WAVE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, 30 + RandomUtils.range(-1, 2), VanillaCopies::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> BMDColors.ENDER_PURPLE);
            particle.setColorVariation(0.2);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)PETAL.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(15, 20), VanillaCopies::buildBillBoardGeometry, false, true)));
        particleEngine.m_107378_((ParticleType)POLLEN.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(15, 20), VanillaCopies::buildBillBoardGeometry, false, true);
            particle.setColorOverride(f -> new Vec3(1.0, 0.9, 0.4));
            particle.setColorVariation(0.15);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf(0.05f * (1.0f - f.floatValue() * 0.25f)));
            int randomRot = RandomUtils.range(0, 360);
            float angularMomentum = (float)RandomUtils.randSign() * 4.0f;
            particle.setRotationOverride(particle1 -> Float.valueOf((float)randomRot + (float)particle1.getAge() * angularMomentum));
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)SPORE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(7, 15), VanillaCopies::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.m_6569_(4.0f);
            particle.setColorOverride(age -> MathUtils.lerpVec(age.floatValue(), BMDColors.GREEN, BMDColors.DARK_GREEN));
            particle.setColorVariation(0.25);
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)SPORE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, 30 + RandomUtils.range(-1, 2), VanillaCopies::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> BMDColors.GREEN);
            particle.setColorVariation(0.35);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        particleEngine.m_107378_((ParticleType)FLUFF.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(15, 20), VanillaCopies::buildBillBoardGeometry, true, true)));
        particleEngine.m_107378_((ParticleType)EARTHDIVE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle((ParticleContext)particleContext, RandomUtils.range(15, 20), VanillaCopies::buildBillBoardGeometry, true, false);
            particle.setColorOverride(f -> BMDColors.RUNIC_BROWN);
            particle.setColorVariation(0.25);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f - f.floatValue() * 0.25f) * 0.35f));
            return particle;
        }));
    }

    public static void register(IEventBus eventBus) {
        PARTICLE_TYPES.register(eventBus);
    }
}

