/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.event;

import com.cerbon.bosses_of_mass_destruction.api.maelstrom.general.event.EventScheduler;
import com.cerbon.bosses_of_mass_destruction.block.custom.LevitationBlockEntity;
import com.cerbon.bosses_of_mass_destruction.capability.ChunkBlockCacheProvider;
import com.cerbon.bosses_of_mass_destruction.capability.LevelEventSchedulerProvider;
import com.cerbon.bosses_of_mass_destruction.capability.PlayerMoveHistoryProvider;
import com.cerbon.bosses_of_mass_destruction.entity.BMDEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bosses_of_mass_destruction")
public class ForgeEvents {
    @SubscribeEvent
    public static void onAttachCapabilitiesLevel(AttachCapabilitiesEvent<Level> event) {
        if (event.getObject() != null) {
            if (!((Level)event.getObject()).getCapability(LevelEventSchedulerProvider.EVENT_SCHEDULER).isPresent()) {
                event.addCapability(new ResourceLocation("bosses_of_mass_destruction", "event_scheduler"), (ICapabilityProvider)new LevelEventSchedulerProvider());
            }
            if (!((Level)event.getObject()).getCapability(ChunkBlockCacheProvider.CHUNK_BLOCK_CACHE).isPresent()) {
                event.addCapability(new ResourceLocation("bosses_of_mass_destruction", "chunk_block_cache_capability"), (ICapabilityProvider)new ChunkBlockCacheProvider());
            }
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        Object object = event.getObject();
        if (object instanceof Player && !(player = (Player)object).getCapability(PlayerMoveHistoryProvider.HISTORICAL_DATA).isPresent()) {
            event.addCapability(new ResourceLocation("bosses_of_mass_destruction", "player_move_history"), (ICapabilityProvider)new PlayerMoveHistoryProvider());
        }
    }

    @SubscribeEvent
    protected static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            event.player.getCapability(PlayerMoveHistoryProvider.HISTORICAL_DATA).ifPresent(data -> {
                Vec3 newPosition;
                Vec3 previousPosition = (Vec3)data.get(0);
                if (previousPosition.m_82557_(newPosition = event.player.m_20182_()) > 5.0) {
                    data.clear();
                }
                data.set(newPosition);
            });
            LevitationBlockEntity.tickFlight((ServerPlayer)event.player);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (level.m_46467_() % 2L == 0L) {
            level.getCapability(LevelEventSchedulerProvider.EVENT_SCHEDULER).ifPresent(EventScheduler::updateEvents);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.world.m_46467_() % 2L == 0L) {
            event.world.getCapability(LevelEventSchedulerProvider.EVENT_SCHEDULER).ifPresent(EventScheduler::updateEvents);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity attacker;
        if (BMDEntities.mobConfig.lichConfig.summonMechanic.isEnabled && (attacker = event.getSource().m_7639_()) != null) {
            BMDEntities.killCounter.afterKilledOtherEntity(attacker, event.getEntityLiving());
        }
    }
}

