/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.lich;

import com.cerbon.bosses_of_mass_destruction.api.maelstrom.general.data.HistoricalData;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.general.random.WeightedRandom;
import com.cerbon.bosses_of_mass_destruction.entity.ai.TargetSwitcher;
import com.cerbon.bosses_of_mass_destruction.entity.ai.action.IActionWithCooldown;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichUtils;
import com.cerbon.bosses_of_mass_destruction.entity.damage.DamageMemory;
import com.cerbon.bosses_of_mass_destruction.entity.damage.IDamageHandler;
import com.cerbon.bosses_of_mass_destruction.entity.damage.StagedDamageHandler;
import com.cerbon.bosses_of_mass_destruction.entity.util.IEntityStats;
import com.cerbon.bosses_of_mass_destruction.entity.util.IEntityTick;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class LichMoveLogic
implements IDamageHandler,
IActionWithCooldown,
IEntityTick<ServerLevel> {
    private final Map<Byte, IActionWithCooldown> actions;
    private final LichEntity actor;
    private final HistoricalData<Byte> moveHistory = new HistoricalData<Byte>((byte)0, 4);
    private final HistoricalData<Vec3> positionalHistory = new HistoricalData<Vec3>(Vec3.f_82478_, 10);
    private final List<Byte> priorityMoves = new ArrayList<Byte>();
    private final StagedDamageHandler stagedDamageHandler;
    private final TargetSwitcher targetSwitcher;

    public LichMoveLogic(Map<Byte, IActionWithCooldown> actions, LichEntity actor, DamageMemory damageMemory) {
        this.actions = actions;
        this.actor = actor;
        this.stagedDamageHandler = new StagedDamageHandler(LichUtils.hpPercentRageModes, () -> this.priorityMoves.addAll(List.of(Byte.valueOf((byte)12), Byte.valueOf((byte)11), Byte.valueOf((byte)8))));
        this.targetSwitcher = new TargetSwitcher((Mob)actor, damageMemory);
    }

    @Override
    public void afterDamage(IEntityStats stats, DamageSource damageSource, float amount, boolean result) {
        this.stagedDamageHandler.afterDamage(stats, damageSource, amount, result);
    }

    @Override
    public boolean shouldDamage(LivingEntity actor, DamageSource damageSource, float amount) {
        return true;
    }

    @Override
    public void beforeDamage(IEntityStats stats, DamageSource damageSource, float amount) {
        this.stagedDamageHandler.beforeDamage(stats, damageSource, amount);
    }

    @Override
    public int perform() {
        Byte moveByte = !this.priorityMoves.isEmpty() ? this.priorityMoves.remove(0) : this.chooseRegularMove();
        IActionWithCooldown action = this.actions.get(moveByte);
        if (action == null) {
            throw new RuntimeException(moveByte + " action not registered as an attack");
        }
        this.actor.f_19853_.m_7605_((Entity)this.actor, moveByte.byteValue());
        return action.perform();
    }

    private Byte chooseRegularMove() {
        this.targetSwitcher.trySwitchTarget();
        WeightedRandom random = new WeightedRandom();
        double teleportWeight = this.getTeleportWeight();
        double minionWeight = this.moveHistory.getAll().contains((byte)7) ? 0.0 : 2.0;
        random.addAll(Arrays.asList(new Pair((Object)1.0, (Object)5), new Pair((Object)1.0, (Object)6), new Pair((Object)minionWeight, (Object)7), new Pair((Object)teleportWeight, (Object)9)));
        Byte nextMove = (Byte)random.next();
        this.moveHistory.set(nextMove);
        return nextMove;
    }

    private double getTeleportWeight() {
        Collection positions = this.positionalHistory.getAll();
        double distanceTraveled = IntStream.range(0, positions.size() - 1).mapToDouble(arg_0 -> LichMoveLogic.lambda$getTeleportWeight$1((List)positions, arg_0)).sum();
        LivingEntity target = this.actor.m_5448_();
        if (target == null) {
            return 0.0;
        }
        return (this.actor.inLineOfSight((Entity)target) ? 0.0 : 4.0) + (distanceTraveled > 0.25 ? 0.0 : 8.0) + (this.actor.m_20182_().m_82554_(target.m_20182_()) < 6.0 ? 8.0 : 0.0);
    }

    @Override
    public void tick(ServerLevel level) {
        this.positionalHistory.set(this.actor.m_20182_());
    }

    private static /* synthetic */ double lambda$getTeleportWeight$1(List positions, int i) {
        return ((Vec3)positions.get(i)).m_82554_((Vec3)positions.get(i + 1));
    }
}

