/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.client.render;

import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.MathUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class NodeBossBarRenderer {
    private final String entityTypeKey;
    private final List<Float> hpPercentages;
    private final ResourceLocation noteTexture;
    private final int textureSize;

    public NodeBossBarRenderer(String entityTypeKey, List<Float> hpPercentages, ResourceLocation noteTexture, int textureSize) {
        this.entityTypeKey = entityTypeKey;
        this.hpPercentages = hpPercentages;
        this.noteTexture = noteTexture;
        this.textureSize = textureSize;
    }

    public void renderBossBar(PoseStack poseStack, int x, int y, BossEvent bossEvent, CallbackInfo callbackInfo) {
        TranslatableComponent translatableContents;
        Component name = bossEvent.m_18861_();
        if (name instanceof TranslatableComponent && (translatableContents = (TranslatableComponent)name).m_131328_().equals(this.entityTypeKey)) {
            float colorLocation = (float)(bossEvent.m_18862_().ordinal() * 5) * 2.0f;
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)colorLocation, (int)182, (int)5, (int)this.textureSize, (int)this.textureSize);
            int i = (int)(bossEvent.m_142717_() * 183.0f);
            if (i > 0) {
                float progressLocation = (float)(bossEvent.m_18862_().ordinal() * 5 * 2) + 5.0f;
                GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)progressLocation, (int)i, (int)5, (int)this.textureSize, (int)this.textureSize);
            }
            this.renderBossNodes(bossEvent, poseStack, x, y);
            callbackInfo.cancel();
        }
    }

    private void renderBossNodes(BossEvent bossEvent, PoseStack poseStack, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.noteTexture);
        int steppedPercentage = (int)(192.0f * MathUtils.roundedStep(bossEvent.m_142717_(), this.hpPercentages, true)) + 7;
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x - 3), (int)(y - 1), (float)0.0f, (float)0.0f, (int)steppedPercentage, (int)7, (int)this.textureSize, (int)this.textureSize);
        int steppedPercentageReverse = 192 - steppedPercentage;
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x - 3 + steppedPercentage), (int)(y - 1), (float)steppedPercentage, (float)7.0f, (int)steppedPercentageReverse, (int)7, (int)this.textureSize, (int)this.textureSize);
    }
}

