/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.item;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.goblintraders.mixin.SpawnEggItemMixin;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class SupplierSpawnEggItem
extends SpawnEggItem {
    private static final List<SupplierSpawnEggItem> EGGS = new ArrayList<SupplierSpawnEggItem>();
    private final Supplier<EntityType<?>> typeSupplier;

    public SupplierSpawnEggItem(Supplier<EntityType<?>> typeSupplier, int primaryColorIn, int secondaryColorIn, Item.Properties builder) {
        super(null, primaryColorIn, secondaryColorIn, builder);
        this.typeSupplier = typeSupplier;
        EGGS.add(this);
    }

    public EntityType<?> m_43228_(CompoundTag tag) {
        return this.typeSupplier.get();
    }

    public static void updateEggMap() {
        SpawnEggItemMixin.getEggMap().remove(null);
        DispenseItemBehavior eggDispenseBehaviour = (source, stack) -> {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            EntityType type = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
            type.m_20592_(source.m_7727_(), stack, null, source.m_7961_().m_142300_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
            stack.m_41774_(1);
            return stack;
        };
        EGGS.forEach(spawnEggItem -> {
            SpawnEggItemMixin.getEggMap().put(spawnEggItem.typeSupplier.get(), (SpawnEggItem)spawnEggItem);
            DispenserBlock.m_52672_((ItemLike)spawnEggItem, (DispenseItemBehavior)eggDispenseBehaviour);
        });
    }

    public static List<SupplierSpawnEggItem> getSupplierEggs() {
        return ImmutableList.copyOf(EGGS);
    }
}

