/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.type.ITradeType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TradeProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private Map<EntityType<?>, EnumMap<TradeRarity, List<ITradeType<?>>>> trades = new HashMap();

    protected TradeProvider(DataGenerator generator) {
        this.generator = generator;
    }

    protected abstract void registerTrades();

    protected final void addTrade(EntityType<?> type, TradeRarity rarity, ITradeType<?> trade) {
        this.trades.putIfAbsent(type, new EnumMap(TradeRarity.class));
        this.trades.get(type).putIfAbsent(rarity, new ArrayList());
        this.trades.get(type).get((Object)rarity).add(trade);
    }

    public void m_6865_(HashCache cache) {
        this.trades.clear();
        this.registerTrades();
        this.trades.forEach((entityType, tradeRarityListEnumMap) -> tradeRarityListEnumMap.forEach((tradeRarity, tradeList) -> {
            JsonObject object = new JsonObject();
            object.addProperty("replace", Boolean.valueOf(false));
            JsonArray tradeArray = new JsonArray();
            tradeList.forEach(trade -> tradeArray.add((JsonElement)trade.serialize()));
            object.add("trades", (JsonElement)tradeArray);
            ResourceLocation id = Objects.requireNonNull(entityType.getRegistryName());
            Path path = this.generator.m_123916_().resolve("data/" + id.m_135827_() + "/trades/" + id.m_135815_() + "/" + tradeRarity.getKey() + ".json");
            try {
                String rawJson = GSON.toJson((JsonElement)object);
                String hash = f_123918_.hashUnencodedChars((CharSequence)rawJson).toString();
                if (!Objects.equals(cache.m_123938_(path), hash) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        writer.write(rawJson);
                    }
                }
                cache.m_123940_(path, hash);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save trades to {}", (Object)path, (Object)e);
            }
        }));
    }

    public String m_6055_() {
        return "Trades: goblintraders";
    }
}

